/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal.bridge;

import java.io.Reader;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.bridge.ContentParser;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultContentParser
implements ContentParser {
    @Inject
    private ComponentManager componentManager;

    @Override
    public XDOM parse(String content, Syntax syntax) throws WikiComponentException {
        XDOM xdom;
        try {
            Parser parser = (Parser)this.componentManager.getInstance(Parser.class, syntax.toIdString());
            xdom = parser.parse((Reader)new StringReader(content));
        }
        catch (Exception e) {
            throw new WikiComponentException(String.format("Failed to parse content [%s]", content), e);
        }
        return xdom;
    }
}

