/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentBuilder;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="defaultWikiComponentManagerEventListener")
@Singleton
public class DefaultWikiComponentManagerEventListener
implements EventListener {
    @Inject
    private Logger logger;
    @Inject
    private WikiComponentManager wikiComponentManager;
    @Inject
    private List<WikiComponentBuilder> wikiComponentProviders;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private Execution execution;

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new ApplicationReadyEvent(), new WikiReadyEvent(), new XARImportedEvent());
    }

    public String getName() {
        return "defaultWikiComponentManagerEventListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        if (source instanceof DocumentModelBridge) {
            DocumentModelBridge document = (DocumentModelBridge)source;
            DocumentReference documentReference = document.getDocumentReference();
            if (event instanceof DocumentCreatedEvent || event instanceof DocumentUpdatedEvent) {
                this.registerComponents(document);
            } else if (event instanceof DocumentDeletedEvent) {
                this.unregisterComponents(documentReference);
            }
        } else if (event instanceof ApplicationReadyEvent || event instanceof WikiReadyEvent) {
            this.registerComponents();
        } else if (event instanceof XARImportedEvent) {
            XWikiContext xcontext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
            xcontext.remove((Object)"grouplist");
            this.registerComponents();
        }
    }

    private void registerComponents() {
        for (WikiComponentBuilder provider : this.wikiComponentProviders) {
            for (DocumentReference reference : provider.getDocumentReferences()) {
                try {
                    List<WikiComponent> components = provider.buildComponents(reference);
                    for (WikiComponent component : components) {
                        this.wikiComponentManager.registerWikiComponent(component);
                    }
                }
                catch (WikiComponentException e) {
                    this.logger.warn("Failed to register the wiki component located in the document [{}]. Root cause: {}", this.compactWikiSerializer.serialize((EntityReference)reference, new Object[0]), (Object)e.getMessage());
                }
            }
        }
    }

    private void registerComponents(DocumentModelBridge document) {
        DocumentReference documentReference = document.getDocumentReference();
        this.unregisterComponents(documentReference);
        for (WikiComponentBuilder provider : this.wikiComponentProviders) {
            if (!provider.getDocumentReferences().contains(documentReference)) continue;
            try {
                List<WikiComponent> components = provider.buildComponents(documentReference);
                for (WikiComponent component : components) {
                    try {
                        this.wikiComponentManager.registerWikiComponent(component);
                    }
                    catch (WikiComponentException e) {
                        this.logger.warn("Unable to register component(s) from document [{}]: {}", this.compactWikiSerializer.serialize((EntityReference)component.getDocumentReference(), new Object[0]), (Object)e.getMessage());
                    }
                }
            }
            catch (WikiComponentException e) {
                this.logger.warn("Failed to create wiki component(s) for document [{}]: {}", this.compactWikiSerializer.serialize((EntityReference)documentReference, new Object[0]), (Object)e.getMessage());
            }
        }
    }

    private void unregisterComponents(DocumentReference documentReference) {
        try {
            this.wikiComponentManager.unregisterWikiComponents(documentReference);
        }
        catch (WikiComponentException e) {
            this.logger.warn("Unable to unregister component(s) from document [{}]: {}", this.compactWikiSerializer.serialize((EntityReference)documentReference, new Object[0]), (Object)e.getMessage());
        }
    }
}

