/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiComponentManager;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.component.wiki.internal.WikiComponentManagerContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultWikiComponentManager
implements WikiComponentManager {
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager rootComponentManager;
    @Inject
    private WikiComponentManagerContext wikiComponentManagerContext;
    private Map<WikiComponent, Boolean> registeredComponents = new ConcurrentHashMap<WikiComponent, Boolean>();

    @Override
    public void registerWikiComponent(WikiComponent component) throws WikiComponentException {
        DocumentReference currentUserReference = this.wikiComponentManagerContext.getCurrentUserReference();
        EntityReference currentEntityReference = this.wikiComponentManagerContext.getCurrentEntityReference();
        try {
            Type roleType = component.getRoleType();
            Class roleTypeClass = ReflectionUtils.getTypeClass((Type)roleType);
            ComponentDescriptor componentDescriptor = this.createComponentDescriptor(roleType, component.getRoleHint());
            this.wikiComponentManagerContext.setCurrentUserReference(component.getAuthorReference());
            this.wikiComponentManagerContext.setCurrentEntityReference((EntityReference)component.getDocumentReference());
            if (this.isInitializable(component.getClass().getInterfaces())) {
                try {
                    ((Initializable)component).initialize();
                }
                catch (InitializationException e) {
                    this.logger.error("Failed to initialize wiki component", (Throwable)e);
                }
            }
            this.getComponentManager(component.getScope()).registerComponent(componentDescriptor, roleTypeClass.cast(component));
            this.registeredComponents.put(component, Boolean.FALSE);
        }
        catch (ComponentLookupException e) {
            throw new WikiComponentException(String.format("Failed to find a component manager for scope [%s] wiki component registration failed", new Object[]{component.getScope()}), e);
        }
        catch (ComponentRepositoryException e) {
            throw new WikiComponentException("Failed to register wiki component against component repository", e);
        }
        finally {
            this.wikiComponentManagerContext.setCurrentUserReference(currentUserReference);
            this.wikiComponentManagerContext.setCurrentEntityReference(currentEntityReference);
        }
    }

    @Override
    public void unregisterWikiComponents(DocumentReference reference) throws WikiComponentException {
        WikiComponent unregisteredComponent = null;
        DocumentReference currentUserReference = this.wikiComponentManagerContext.getCurrentUserReference();
        EntityReference currentEntityReference = this.wikiComponentManagerContext.getCurrentEntityReference();
        for (WikiComponent registered : this.registeredComponents.keySet()) {
            if (!registered.getDocumentReference().equals((Object)reference)) continue;
            unregisteredComponent = registered;
            try {
                this.wikiComponentManagerContext.setCurrentUserReference(registered.getAuthorReference());
                this.wikiComponentManagerContext.setCurrentEntityReference((EntityReference)registered.getDocumentReference());
                this.getComponentManager(registered.getScope()).unregisterComponent(registered.getRoleType(), registered.getRoleHint());
            }
            catch (ComponentLookupException e) {
                throw new WikiComponentException(String.format("Failed to find a component manager for scope [%s]", new Object[]{registered.getScope()}), e);
            }
            finally {
                this.wikiComponentManagerContext.setCurrentUserReference(currentUserReference);
                this.wikiComponentManagerContext.setCurrentEntityReference(currentEntityReference);
            }
        }
        if (unregisteredComponent != null) {
            this.registeredComponents.remove(reference);
        }
    }

    private ComponentManager getComponentManager(WikiComponentScope scope) throws ComponentLookupException {
        ComponentManager cm;
        switch (scope) {
            case USER: {
                cm = (ComponentManager)this.rootComponentManager.getInstance(ComponentManager.class, "user");
                break;
            }
            case WIKI: {
                cm = (ComponentManager)this.rootComponentManager.getInstance(ComponentManager.class, "wiki");
                break;
            }
            default: {
                cm = this.rootComponentManager;
            }
        }
        return cm;
    }

    private ComponentDescriptor createComponentDescriptor(Type roleType, String roleHint) {
        DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
        cd.setRoleType(roleType);
        cd.setRoleHint(roleHint);
        return cd;
    }

    private boolean isInitializable(Class<?>[] interfaces) {
        for (Class<?> iface : interfaces) {
            if (!Initializable.class.equals(iface)) continue;
            return true;
        }
        return false;
    }
}

