/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.internal.WikiComponentConstants;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="defaultWikiComponentBuilderEventListener")
@Singleton
public class DefaultWikiComponentBuilderEventListener
implements EventListener,
WikiComponentConstants {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;

    public List<Event> getEvents() {
        return Arrays.asList(new ApplicationReadyEvent(), new WikiReadyEvent());
    }

    public String getName() {
        return "defaultWikiComponentBuilderEventListener";
    }

    public void onEvent(Event arg0, Object arg1, Object arg2) {
        try {
            this.installOrUpdateComponentXClass();
            this.installOrUpdateComponentRequirementXClass();
            this.installOrUpdateComponentMethodXClass();
            this.installOrUpdateComponentInterfaceXClass();
        }
        catch (XWikiException e) {
            this.logger.error("Failed to install or update wiki component XClasses", (Throwable)e);
        }
    }

    private void installOrUpdateComponentInterfaceXClass() throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        XWikiDocument doc = xcontext.getWiki().getDocument("XWiki.ComponentInterfaceClass", xcontext);
        BaseClass bclass = doc.getXClass();
        bclass.setName("XWiki.ComponentInterfaceClass");
        boolean needsUpdate = false;
        needsUpdate |= this.initializeXClassDocumentMetadata(doc, "Wiki Component Implements Interface XWiki Class");
        if (needsUpdate |= bclass.addTextField("name", "Interface Qualified Name", 30)) {
            this.update(doc);
        }
    }

    private void installOrUpdateComponentXClass() throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        XWikiDocument doc = xcontext.getWiki().getDocument("XWiki.ComponentClass", xcontext);
        BaseClass bclass = doc.getXClass();
        bclass.setName("XWiki.ComponentClass");
        boolean needsUpdate = false;
        needsUpdate |= this.initializeXClassDocumentMetadata(doc, "Wiki Component XWiki Class");
        needsUpdate |= bclass.addTextField("roleType", "Component Role Type", 30);
        needsUpdate |= bclass.addTextField("roleHint", "Component Role Hint", 30);
        if (needsUpdate |= bclass.addStaticListField("scope", "Component Scope", 1, false, "wiki=Current Wiki|user=Current User|global=Global", "select")) {
            this.update(doc);
        }
    }

    private void installOrUpdateComponentRequirementXClass() throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        XWikiDocument doc = xcontext.getWiki().getDocument("XWiki.ComponentDependencyClass", xcontext);
        BaseClass bclass = doc.getXClass();
        bclass.setName("XWiki.ComponentDependencyClass");
        boolean needsUpdate = false;
        needsUpdate |= this.initializeXClassDocumentMetadata(doc, "Wiki Component Dependency XWiki Class");
        needsUpdate |= bclass.addTextField("roleType", "Dependency Role Type", 30);
        needsUpdate |= bclass.addTextField("roleHint", "Dependency Role Hint", 30);
        if (needsUpdate |= bclass.addTextField("bindingName", "Binding name", 30)) {
            this.update(doc);
        }
    }

    private void installOrUpdateComponentMethodXClass() throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        XWikiDocument doc = xcontext.getWiki().getDocument("XWiki.ComponentMethodClass", xcontext);
        BaseClass bclass = doc.getXClass();
        bclass.setName("XWiki.ComponentMethodClass");
        boolean needsUpdate = false;
        needsUpdate |= this.initializeXClassDocumentMetadata(doc, "Wiki Component Method XWiki Class");
        needsUpdate |= bclass.addTextField("name", "Method name", 30);
        if (needsUpdate |= bclass.addTextAreaField("code", "Method body code", 40, 20)) {
            this.update(doc);
        }
    }

    private void update(XWikiDocument doc) throws XWikiException {
        XWikiContext xcontext = this.getXWikiContext();
        xcontext.getWiki().saveDocument(doc, xcontext);
    }

    private boolean initializeXClassDocumentMetadata(XWikiDocument doc, String title) {
        boolean needsUpdate = false;
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle(title);
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((Object)doc.getSyntax())) {
            needsUpdate = true;
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        return needsUpdate;
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

