/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.configuration.ConfigurationRight;
import org.xwiki.configuration.ConfigurationSourceAuthorization;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

public abstract class AbstractDocumentConfigurationSourceAuthorization
implements ConfigurationSourceAuthorization {
    @Inject
    protected AuthorizationManager authorizationManager;
    @Inject
    @Named(value="document")
    protected UserReferenceSerializer<DocumentReference> bridgeSerializer;

    public boolean hasAccess(String key, UserReference userReference, ConfigurationRight right) {
        DocumentReference userDocumentReference = this.getUserDocumentReference(userReference);
        Right entityRight = this.getEntityRight(right);
        return this.authorizationManager.hasAccess(entityRight, userDocumentReference, (EntityReference)this.getDocumentReference());
    }

    protected DocumentReference getUserDocumentReference(UserReference userReference) {
        return (DocumentReference)this.bridgeSerializer.serialize(userReference);
    }

    protected Right getEntityRight(ConfigurationRight right) {
        return right == ConfigurationRight.READ ? Right.VIEW : Right.EDIT;
    }

    protected abstract DocumentReference getDocumentReference();
}

