/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.ConversionException;
import org.xwiki.properties.ConverterManager;

public class CommonsConfigurationSource
implements ConfigurationSource {
    private Configuration configuration;
    @Inject
    private ConverterManager converterManager;

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public <T> T getProperty(String key, T defaultValue) {
        return this.getProperty(key, defaultValue, defaultValue.getClass());
    }

    public <T> T getProperty(String key) {
        return (T)this.configuration.getProperty(key);
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        Object result = null;
        try {
            if (String.class.getName().equals(valueClass.getName())) {
                result = this.configuration.getString(key);
            } else if (List.class.isAssignableFrom(valueClass)) {
                result = this.configuration.getList(key);
            } else if (Properties.class.isAssignableFrom(valueClass)) {
                result = this.configuration.getProperties(key);
            } else if (null != this.getProperty(key)) {
                result = this.converterManager.convert(valueClass, this.getProperty(key));
            }
        }
        catch (org.apache.commons.configuration.ConversionException e) {
            throw new ConversionException("Key [" + key + "] is not of type [" + valueClass.getName() + "]", (Throwable)e);
        }
        catch (org.xwiki.properties.converter.ConversionException e) {
            throw new ConversionException("Key [" + key + "] is not of type [" + valueClass.getName() + "]", (Throwable)e);
        }
        return (T)result;
    }

    public List<String> getKeys() {
        ArrayList<String> keysList = new ArrayList<String>();
        Iterator keys = this.configuration.getKeys();
        while (keys.hasNext()) {
            keysList.add((String)keys.next());
        }
        return keysList;
    }

    public boolean containsKey(String key) {
        return this.configuration.containsKey(key);
    }

    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    private <T> T getProperty(String key, T defaultValue, Class<T> valueClass) {
        T result = this.getProperty(key, valueClass);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }
}

