/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import org.xwiki.configuration.internal.AbstractDocumentConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.SpaceReference;

public abstract class AbstractXWikiPreferencesConfigurationSource
extends AbstractDocumentConfigurationSource {
    protected static final String CLASS_SPACE_NAME = "XWiki";
    protected static final String CLASS_PAGE_NAME = "XWikiPreferences";
    protected static final LocalDocumentReference CLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiPreferences");

    @Override
    protected String getCacheKeyPrefix() {
        return this.wikiManager.getCurrentWikiId();
    }

    @Override
    protected LocalDocumentReference getClassReference() {
        return CLASS_REFERENCE;
    }

    @Override
    protected DocumentReference getDocumentReference() {
        return new DocumentReference(CLASS_REFERENCE.getName(), new SpaceReference(CLASS_SPACE_NAME, this.getCurrentWikiReference()));
    }

    protected BaseObject getBaseObject(String language) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            DocumentReference documentReference = this.getFailsafeDocumentReference();
            LocalDocumentReference classReference = this.getFailsafeClassReference();
            if (documentReference != null && classReference != null) {
                XWikiDocument document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
                return this.getBaseObject(document, language);
            }
        }
        return null;
    }

    protected BaseObject getBaseObject(XWikiDocument document, String language) {
        if (language != null) {
            BaseObject object = document.getXObject((EntityReference)this.getClassReference(), "default_language", language, true);
            if (object != null) {
                return object;
            }
        } else {
            return document.getXObject((EntityReference)this.getClassReference());
        }
        return null;
    }

    @Override
    protected BaseObject getBaseObject() throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            DocumentReference documentReference = this.getFailsafeDocumentReference();
            LocalDocumentReference classReference = this.getFailsafeClassReference();
            if (documentReference != null && classReference != null) {
                XWikiDocument document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
                BaseObject object = this.getBaseObject(document, xcontext.getLanguage());
                if (object != null) {
                    return object;
                }
                return document.getXObject((EntityReference)classReference);
            }
        }
        return null;
    }

    protected Object getBaseProperty(String propertyName, String language, boolean text) throws XWikiException {
        BaseObject baseObject = this.getBaseObject(language);
        if (baseObject != null) {
            BaseProperty property = (BaseProperty)baseObject.getField(propertyName);
            return property != null ? (text ? property.toText() : property.getValue()) : null;
        }
        return null;
    }

    @Override
    protected Object getBaseProperty(String propertyName, boolean text) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        Object propertyValue = this.getBaseProperty(propertyName, xcontext.getLanguage(), text);
        if (propertyValue == null || this.isEmpty(propertyValue)) {
            propertyValue = this.getBaseProperty(propertyName, null, text);
        }
        if (this.isEmpty(propertyValue)) {
            propertyValue = null;
        }
        return propertyValue;
    }
}

