/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.Request;
import org.xwiki.container.RequestInitializer;
import org.xwiki.container.RequestInitializerException;
import org.xwiki.container.RequestInitializerManager;

@Component
@Singleton
public class DefaultRequestInitializerManager
implements RequestInitializerManager {
    @Inject
    private ComponentManager componentManager;

    @Override
    public void initializeRequest(Request request) throws RequestInitializerException {
        try {
            for (RequestInitializer interceptor : this.componentManager.lookupList(RequestInitializer.class)) {
                interceptor.initialize(request);
            }
        }
        catch (ComponentLookupException e) {
            throw new RequestInitializerException("Failed to initialize request", e);
        }
    }
}

