/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.xwiki.container.Request;

public class ServletRequest
implements Request {
    private HttpServletRequest httpServletRequest;

    public ServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public Object getProperty(String key) {
        Object result = this.httpServletRequest.getParameter(key);
        if (result == null) {
            result = this.httpServletRequest.getAttribute(key);
        }
        return result;
    }

    public List<Object> getProperties(String key) {
        ArrayList<Object> result = new ArrayList<Object>();
        String[] requestParameters = this.httpServletRequest.getParameterValues(key);
        if (requestParameters != null) {
            result.addAll(Arrays.asList(requestParameters));
        }
        result.add(this.httpServletRequest.getAttribute(key));
        return result;
    }

    public void setProperty(String key, Object value) {
        this.httpServletRequest.setAttribute(key, value);
    }

    public void removeProperty(String key) {
        this.httpServletRequest.removeAttribute(key);
    }
}

