/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.internal.StackingComponentEventManager;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.ApplicationContextListenerManager;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.ApplicationStoppedEvent;
import org.xwiki.observation.event.Event;

public class XWikiServletContextListener
implements ServletContextListener {
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    private EmbeddableComponentManager componentManager;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ObservationManager observationManager;
        EmbeddableComponentManager ecm = new EmbeddableComponentManager();
        ecm.initialize(this.getClass().getClassLoader());
        this.componentManager = ecm;
        servletContextEvent.getServletContext().setAttribute(ComponentManager.class.getName(), (Object)this.componentManager);
        StackingComponentEventManager eventManager = new StackingComponentEventManager();
        this.componentManager.setComponentEventManager((ComponentEventManager)eventManager);
        try {
            ServletEnvironment servletEnvironment = (ServletEnvironment)this.componentManager.getInstance(Environment.class);
            servletEnvironment.setServletContext(servletContextEvent.getServletContext());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize the Servlet Environment", e);
        }
        try {
            ServletContainerInitializer containerInitializer = (ServletContainerInitializer)this.componentManager.getInstance(ServletContainerInitializer.class);
            containerInitializer.initializeApplicationContext(servletContextEvent.getServletContext());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize the Application Context", e);
        }
        try {
            observationManager = (ObservationManager)this.componentManager.getInstance(ObservationManager.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to find the Observation Manager component", e);
        }
        eventManager.setObservationManager(observationManager);
        eventManager.shouldStack(false);
        eventManager.flushEvents();
        observationManager.notify((Event)new ApplicationStartedEvent(), (Object)this);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        SHUTDOWN_LOGGER.debug("Stopping XWiki...");
        if (this.componentManager != null) {
            try {
                ObservationManager observationManager = (ObservationManager)this.componentManager.getInstance(ObservationManager.class);
                observationManager.notify((Event)new ApplicationStoppedEvent(), (Object)this);
            }
            catch (ComponentLookupException e) {
                // empty catch block
            }
            try {
                ApplicationContextListenerManager applicationContextListenerManager = (ApplicationContextListenerManager)this.componentManager.getInstance(ApplicationContextListenerManager.class);
                Container container = (Container)this.componentManager.getInstance(Container.class);
                applicationContextListenerManager.destroyApplicationContext(container.getApplicationContext());
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
            this.componentManager.dispose();
            SHUTDOWN_LOGGER.debug("XWiki has been stopped!");
        }
    }
}

