/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric.factory;

import javax.inject.Named;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.CipherFactory;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;

public abstract class AbstractBcSymmetricCipherFactory
implements CipherFactory {
    protected abstract BlockCipher getEngineInstance();

    protected abstract BlockCipher getCipherInstance(boolean var1, SymmetricCipherParameters var2);

    protected static int[] newKeySizeArray(int minSize, int maxSize, int step) {
        int[] result = new int[(maxSize - minSize) / step + 1];
        int i = minSize;
        int j = 0;
        while (i <= maxSize) {
            result[j] = i;
            i += step;
            ++j;
        }
        return result;
    }

    @Override
    public String getCipherAlgorithmName() {
        String hint = null;
        Named named = this.getClass().getAnnotation(Named.class);
        if (named != null) {
            hint = named.value();
        } else {
            Component component = this.getClass().getAnnotation(Component.class);
            if (component != null && component.hints().length > 0) {
                hint = component.hints()[0];
            }
        }
        return hint;
    }

    @Override
    public int getIVSize() {
        return this.getEngineInstance().getBlockSize();
    }

    @Override
    public int getKeySize() {
        int[] sizes = this.getSupportedKeySizes();
        return sizes[sizes.length - 1];
    }

    @Override
    public boolean isSupportedKeySize(int keySize) {
        int[] sizes;
        for (int i : sizes = this.getSupportedKeySizes()) {
            if (i != keySize) continue;
            return true;
        }
        return false;
    }

    protected CipherParameters getBcKeyParameter(KeyParameter parameter) {
        return new org.bouncycastle.crypto.params.KeyParameter(parameter.getKey());
    }
}

