/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.internal.UserDocumentUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultUserDocumentUtils
implements UserDocumentUtils {
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    @Override
    public String getCurrentUser() {
        String localName = this.bridge.getCurrentUser();
        DocumentReference dr = this.resolver.resolve((Object)localName, new Object[0]);
        return (String)this.serializer.serialize((EntityReference)dr, new Object[0]);
    }

    @Override
    public String getUserDocURL(String userDocName) {
        DocumentReference dr = this.resolver.resolve((Object)userDocName, new Object[0]);
        return this.bridge.getDocumentURL(dr, "view", "", "", true);
    }
}

