/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.x509.internal;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Vector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JDKKeyPairGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public class X509Keymaker {
    private static final String CA_ORGANIZATION_NAME = "Fake authorities for trusting client certificates";
    private final X509V3CertificateGenerator certGenerator = new X509V3CertificateGenerator();
    private final JDKKeyPairGenerator.RSA keyPairGen = new JDKKeyPairGenerator.RSA();
    private final long anHour = 3600000L;
    private final long aDay = 86400000L;
    private final String certSignatureAlgorithm = "SHA1WithRSAEncryption";
    private KeyPair authorityKeyPair;
    private X509Certificate authorityCertificate;

    public X509Keymaker() {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public KeyPair newKeyPair() {
        return this.keyPairGen.generateKeyPair();
    }

    public void setAuthorityKeyPair(KeyPair authorityKeyPair) {
        this.authorityKeyPair = authorityKeyPair;
    }

    public void setAuthorityCertificate(X509Certificate authorityCertificate) {
        this.authorityCertificate = authorityCertificate;
    }

    public X509Certificate getAuthorityCertificate() {
        return this.authorityCertificate;
    }

    public synchronized X509Certificate[] makeClientAndAuthorityCertificates(PublicKey forCert, int daysOfValidity, boolean nonRepudiable, String webId, String userName) throws GeneralSecurityException {
        KeyPair auth = this.authorityKeyPair;
        if (auth == null) {
            auth = this.newKeyPair();
        }
        X509Certificate[] out = new X509Certificate[]{this.makeClientCertificate(forCert, auth, daysOfValidity, nonRepudiable, webId, userName), this.getAuthorityCertificate()};
        if (out[1] == null) {
            out[1] = this.makeCertificateAuthority(auth, daysOfValidity, webId);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized X509Certificate makeClientCertificate(PublicKey forCert, KeyPair toSignWith, int daysOfValidity, boolean nonRepudiable, String webId, String userName) throws GeneralSecurityException {
        try {
            X509Name dName = new X509Name("UID=" + userName);
            this.prepareGenericCertificate(forCert, daysOfValidity, dName, dName);
            this.certGenerator.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(false));
            this.certGenerator.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (DEREncodable)new NetscapeCertType(160));
            int keyUsage = 184;
            if (nonRepudiable) {
                keyUsage |= 0x40;
            }
            this.certGenerator.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(keyUsage));
            this.certGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(toSignWith.getPublic()));
            GeneralNames subjectAltNames = new GeneralNames(new GeneralName(6, webId));
            this.certGenerator.addExtension(X509Extensions.SubjectAlternativeName, true, (DEREncodable)subjectAltNames);
            X509Certificate x509Certificate = this.generate(toSignWith);
            return x509Certificate;
        }
        finally {
            this.certGenerator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized X509Certificate makeCertificateAuthority(KeyPair keyPair, int daysOfValidity, final String commonName) throws GeneralSecurityException {
        try {
            X509Name name = new X509Name((Vector)new Vector<DERObjectIdentifier>(){
                {
                    this.add(X509Name.O);
                    this.add(X509Name.CN);
                }
            }, (Vector)new Vector<String>(){
                {
                    this.add(X509Keymaker.CA_ORGANIZATION_NAME);
                    this.add(commonName);
                }
            });
            this.prepareGenericCertificate(keyPair.getPublic(), daysOfValidity, name, name);
            this.certGenerator.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(0));
            this.certGenerator.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(4));
            this.certGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(keyPair.getPublic()));
            X509Certificate x509Certificate = this.generate(keyPair);
            return x509Certificate;
        }
        finally {
            this.certGenerator.reset();
        }
    }

    private synchronized void prepareGenericCertificate(PublicKey forCert, int daysOfValidity, X509Name subjectDN, X509Name issuerDN) {
        this.certGenerator.reset();
        this.certGenerator.setNotBefore(new Date(System.currentTimeMillis() - this.anHour));
        this.certGenerator.setNotAfter(new Date(System.currentTimeMillis() + this.aDay * (long)daysOfValidity));
        this.certGenerator.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()).abs());
        this.certGenerator.setPublicKey(forCert);
        this.certGenerator.setSignatureAlgorithm(this.certSignatureAlgorithm);
        this.certGenerator.setSubjectDN(subjectDN);
        this.certGenerator.setIssuerDN(issuerDN);
    }

    private synchronized X509Certificate generate(KeyPair toSignWith) throws GeneralSecurityException {
        X509Certificate cert = this.certGenerator.generate(toSignWith.getPrivate());
        cert.verify(toSignWith.getPublic());
        return cert;
    }
}

