/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal;

import java.io.UnsupportedEncodingException;
import org.bouncycastle.util.encoders.Base64;

public final class Convert {
    private static final String CHARSET = "UTF-8";
    private static final int DEFAULT_LINE_LENGTH = 64;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");

    private Convert() {
    }

    public static String toBase64String(byte[] data) {
        try {
            return new String(Convert.toBase64(data), CHARSET);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String toChunkedBase64String(byte[] data) {
        return Convert.toChunkedBase64String(data, 64);
    }

    public static String toChunkedBase64String(byte[] data, int lineLength) {
        StringBuilder result = new StringBuilder();
        String encoded = Convert.toBase64String(data);
        int begin = 0;
        for (int end = lineLength; end < encoded.length(); end += lineLength) {
            result.append(encoded.substring(begin, end));
            result.append(NEWLINE);
            begin = end;
        }
        result.append(encoded.substring(begin));
        result.append(NEWLINE);
        return result.toString();
    }

    public static byte[] toBase64(byte[] data) {
        if (data == null) {
            return new byte[0];
        }
        return Base64.encode((byte[])data);
    }

    public static byte[] fromBase64String(String withBase64EncodedContent, String beginningMarker, String endMarker) {
        return Convert.fromBase64(Convert.stringToBytes(withBase64EncodedContent, beginningMarker, endMarker));
    }

    public static byte[] fromBase64String(String base64Encoded) {
        return Convert.fromBase64(Convert.stringToBytes(base64Encoded));
    }

    public static byte[] fromBase64(byte[] base64Encoded) {
        if (base64Encoded == null || base64Encoded.length == 0) {
            return new byte[0];
        }
        return Base64.decode((byte[])base64Encoded);
    }

    public static String getContentBetween(String input, String beginningMarker, String endMarker) {
        if (input == null) {
            throw new IllegalArgumentException("Given string is null");
        }
        int beginIndex = input.indexOf(beginningMarker);
        if (beginIndex < 0) {
            throw new IllegalArgumentException("No beginning marker found in string\nExpecting: " + beginningMarker);
        }
        int endIndex = input.indexOf(endMarker, beginIndex);
        if (endIndex < 0) {
            throw new IllegalArgumentException("No end marker found in string\nExpecting: " + endMarker);
        }
        return input.substring(beginIndex += beginningMarker.length(), endIndex);
    }

    public static byte[] stringToBytes(String withBase64EncodedContent, String beginningMarker, String endMarker) {
        return Convert.stringToBytes(Convert.getContentBetween(withBase64EncodedContent, beginningMarker, endMarker));
    }

    public static byte[] stringToBytes(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String bytesToString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            return new String(bytes, CHARSET);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String getNewline() {
        return NEWLINE;
    }
}

