/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Properties;
import org.xwiki.crypto.internal.SerializationUtils;
import org.xwiki.crypto.passwd.KeyDerivationFunction;

public abstract class AbstractKeyDerivationFunction
implements KeyDerivationFunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient int saltSize = 16;
    private final transient int defaultMillisecondsOfProcessorTime = 200;
    private final transient int defaultDerivedKeyLength = 32;

    @Override
    public byte[] serialize() throws IOException {
        return SerializationUtils.serialize(this);
    }

    @Override
    public void init() {
        this.init(this.getDefaultMillisecondsOfProcessorTime(), this.getDefaultDerivedKeyLength());
    }

    @Override
    public void init(Properties parameters) {
        int keyLength = this.getDefaultDerivedKeyLength();
        int milliseconds = this.getDefaultMillisecondsOfProcessorTime();
        try {
            String keyLengthString;
            String millisecondsString = parameters.getProperty("millisecondsOfProcessorTimeToSpend");
            if (millisecondsString != null) {
                milliseconds = Integer.parseInt(millisecondsString);
            }
            if ((keyLengthString = parameters.getProperty("derivedKeyLength")) != null) {
                keyLength = Integer.parseInt(keyLengthString);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse Properties", e);
        }
        this.init(milliseconds, keyLength);
    }

    @Override
    public void init(int millisecondsOfProcessorTimeToSpend, int derivedKeyLength) {
        byte[] salt = new byte[this.saltSize];
        new SecureRandom().nextBytes(salt);
        int testIterationCount = 20;
        this.init(salt, testIterationCount, derivedKeyLength);
        int testLength = millisecondsOfProcessorTimeToSpend / 100;
        if (testLength < 4) {
            testLength = 4;
        }
        long time = System.currentTimeMillis();
        int numberOfCycles = 0;
        while (System.currentTimeMillis() - time < (long)testLength) {
            this.deriveKey(salt);
            numberOfCycles += testIterationCount;
        }
        int iterationCount = millisecondsOfProcessorTimeToSpend / testLength * numberOfCycles;
        this.init(salt, iterationCount, derivedKeyLength);
    }

    public abstract void init(byte[] var1, int var2, int var3);

    protected int getDefaultMillisecondsOfProcessorTime() {
        return this.defaultMillisecondsOfProcessorTime;
    }

    protected int getDefaultDerivedKeyLength() {
        return this.defaultDerivedKeyLength;
    }
}

