/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.x509;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.xwiki.crypto.internal.Convert;
import org.xwiki.crypto.x509.internal.AbstractX509CertificateWrapper;

public class XWikiX509Certificate
extends AbstractX509CertificateWrapper {
    private static final String CERT_TYPE = "X509";
    private static final String FINGERPRINT_ALGORITHM = "SHA1";
    private static final String CERT_BEGIN = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_END = "-----END CERTIFICATE-----";
    private final String fingerprint;
    private final String issuerFingerprint;

    public XWikiX509Certificate(X509Certificate certificate) {
        this(certificate, null);
    }

    public XWikiX509Certificate(X509Certificate certificate, String issuerFp) {
        super(certificate);
        this.fingerprint = XWikiX509Certificate.calculateFingerprint(certificate);
        this.issuerFingerprint = issuerFp == null && certificate instanceof XWikiX509Certificate ? ((XWikiX509Certificate)certificate).getIssuerFingerprint() : (issuerFp == null ? this.fingerprint : issuerFp);
    }

    public static String calculateFingerprint(Certificate certificate) {
        try {
            MessageDigest hash = MessageDigest.getInstance(FINGERPRINT_ALGORITHM);
            BigInteger result = new BigInteger(1, hash.digest(certificate.getEncoded()));
            return String.format("%0" + hash.getDigestLength() * 2 + "x", result);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int hashCode() {
        return this.fingerprint.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XWikiX509Certificate) {
            XWikiX509Certificate cert = (XWikiX509Certificate)obj;
            return this.getFingerprint().equals(cert.getFingerprint());
        }
        return false;
    }

    @Override
    public String toString() {
        String format = "%20s : %s\n";
        StringBuilder builder = new StringBuilder();
        builder.append("XWikiX509Certificate\n");
        builder.append("---------------------------------------------------------------\n");
        builder.append(String.format("%20s : %s\n", "Fingerprint", this.getFingerprint()));
        builder.append(String.format("%20s : %s\n", "SubjectDN", this.getAuthorName()));
        builder.append(String.format("%20s : %s\n", "IssuerDN", this.getIssuerName()));
        builder.append(String.format("%20s : %s\n", "Issuer Fingerprint", this.getIssuerFingerprint()));
        builder.append(String.format("%20s : %s\n", "SerialNumber", this.getSerialNumber().toString(16)));
        builder.append(String.format("%20s : %s\n", "Start Date", this.getNotBefore()));
        builder.append(String.format("%20s : %s\n", "Final Date", this.getNotAfter()));
        builder.append(String.format("%20s : %s\n", "Public Key Algorithm", this.getPublicKey().getAlgorithm()));
        builder.append(String.format("%20s : %s\n", "Signature Algorithm", this.getSigAlgName()));
        try {
            builder.append(this.toPEMString());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return builder.toString();
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String toPEMString() throws CertificateEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append(CERT_BEGIN);
        builder.append(Convert.getNewline());
        builder.append(Convert.toChunkedBase64String(this.certificate.getEncoded()));
        builder.append(CERT_END);
        builder.append(Convert.getNewline());
        return builder.toString();
    }

    public static XWikiX509Certificate fromPEMString(String pemEncoded) throws GeneralSecurityException {
        byte[] base64Bytes = Convert.fromBase64String(pemEncoded, CERT_BEGIN, CERT_END);
        CertificateFactory factory = CertificateFactory.getInstance(CERT_TYPE);
        Certificate cert = factory.generateCertificate(new ByteArrayInputStream(base64Bytes));
        if (!(cert instanceof X509Certificate)) {
            throw new GeneralSecurityException("Unsupported certificate type: " + cert.getType());
        }
        int second = pemEncoded.indexOf(CERT_BEGIN, pemEncoded.indexOf(CERT_END));
        if (second > 0) {
            byte[] cert2 = Convert.fromBase64String(pemEncoded.substring(second), CERT_BEGIN, CERT_END);
            try {
                String issuerFp = XWikiX509Certificate.calculateFingerprint(factory.generateCertificate(new ByteArrayInputStream(cert2)));
                return new XWikiX509Certificate((X509Certificate)cert, issuerFp);
            }
            catch (GeneralSecurityException exception) {
                // empty catch block
            }
        }
        return new XWikiX509Certificate((X509Certificate)cert);
    }

    public static XWikiX509Certificate[] fromCertificateChain(Certificate[] x509Chain) {
        XWikiX509Certificate[] outChain = new XWikiX509Certificate[x509Chain.length];
        String issuerFP = null;
        for (int i = x509Chain.length - 1; i >= 0; --i) {
            if (!(x509Chain[i] instanceof X509Certificate)) {
                throw new IllegalArgumentException("Only X509 certificates are supported, found: " + x509Chain[i].getType());
            }
            outChain[i] = new XWikiX509Certificate((X509Certificate)x509Chain[i], issuerFP);
            issuerFP = outChain[i].getFingerprint();
        }
        return outChain;
    }

    public String getIssuerName() {
        return this.getIssuerX500Principal().getName();
    }

    public String getIssuerFingerprint() {
        return this.issuerFingerprint;
    }

    public String getAuthorName() {
        return this.getSubjectX500Principal().getName();
    }

    public String getAuthorUID() {
        try {
            X509Principal author = PrincipalUtil.getSubjectX509Principal((X509Certificate)this.certificate);
            if (author.getValues(X509Name.UID).size() == 0) {
                return "";
            }
            return (String)author.getValues(X509Name.UID).get(0);
        }
        catch (CertificateEncodingException exception) {
            return "";
        }
    }
}

