/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.passwd.internal;

import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.crypto.passwd.KeyDerivationFunction;
import org.xwiki.crypto.passwd.PasswordCiphertext;
import org.xwiki.crypto.passwd.PasswordCryptoServiceConfiguration;
import org.xwiki.crypto.passwd.PasswordVerificationFunction;
import org.xwiki.crypto.passwd.internal.CAST5PasswordCiphertext;
import org.xwiki.crypto.passwd.internal.DefaultPasswordVerificationFunction;
import org.xwiki.crypto.passwd.internal.PBKDF2KeyDerivationFunction;

@Component
@Singleton
public class DefaultPasswordCryptoServiceConfiguration
implements PasswordCryptoServiceConfiguration {
    @Inject
    private Logger logger;
    private final Properties defaultKeyDerivationFunctionProperties = new Properties(){
        {
            this.setProperty("millisecondsOfProcessorTimeToSpend", "200");
            this.setProperty("numberOfKilobytesOfMemoryToUse", "1024");
            this.setProperty("derivedKeyLength", "32");
        }
    };
    private final String configurationPrefix = "crypto.passwd.";
    private final String cipherKey = "PasswordCiphertext";
    private final Class<?> defaultCipherClass = CAST5PasswordCiphertext.class;
    private final String keyDerivationFunctionClassForEncryption = "keyDerivationFunctionClassForEncryption";
    private final Class<?> defaultKeyDerivationFunctionClassForEncryption = PBKDF2KeyDerivationFunction.class;
    private final String keyDerivationFunctionPropertiesForEncryption = "keyDerivationFunctionPropertiesForEncryption";
    private final Properties defaultKeyDerivationFunctionPropertiesForEncryption = this.defaultKeyDerivationFunctionProperties;
    private final String passwordVerificationFunctionClass = "PasswordVerificationFunction";
    private final Class<?> defaultPasswordVerificationFunctionClass = DefaultPasswordVerificationFunction.class;
    private final String keyDerivationFunctionClassForPasswordVerification = "keyDerivationFunctionClassForPasswordVerification";
    private final Class<?> defaultKeyDerivationFunctionClassForPasswordVerification = PBKDF2KeyDerivationFunction.class;
    private final String keyDerivationFunctionPropertiesForPasswordVerification = "keyDerivationFunctionPropertiesForPasswordVerification";
    private final Properties defaultKeyDerivationFunctionPropertiesForPasswordVerification = this.defaultKeyDerivationFunctionProperties;
    @Inject
    private ConfigurationSource source;

    @Override
    public Class<? extends PasswordCiphertext> getCipherClass() {
        return this.getClass(this.configurationPrefix + this.cipherKey, PasswordCiphertext.class, this.defaultCipherClass);
    }

    @Override
    public Class<? extends KeyDerivationFunction> getKeyDerivationFunctionClassForEncryption() {
        return this.getClass(this.configurationPrefix + this.keyDerivationFunctionClassForEncryption, KeyDerivationFunction.class, this.defaultKeyDerivationFunctionClassForEncryption);
    }

    @Override
    public Properties getKeyDerivationFunctionPropertiesForEncryption() {
        return new Properties((Properties)this.source.getProperty(this.keyDerivationFunctionPropertiesForEncryption, (Object)this.defaultKeyDerivationFunctionPropertiesForEncryption));
    }

    @Override
    public Class<? extends PasswordVerificationFunction> getPasswordVerificationFunctionClass() {
        return this.getClass(this.configurationPrefix + this.passwordVerificationFunctionClass, PasswordVerificationFunction.class, this.defaultPasswordVerificationFunctionClass);
    }

    @Override
    public Class<? extends KeyDerivationFunction> getKeyDerivationFunctionClassForPasswordVerification() {
        return this.getClass(this.configurationPrefix + this.keyDerivationFunctionClassForPasswordVerification, KeyDerivationFunction.class, this.defaultKeyDerivationFunctionClassForPasswordVerification);
    }

    @Override
    public Properties getKeyDerivationFunctionPropertiesForPasswordVerification() {
        return new Properties((Properties)this.source.getProperty(this.keyDerivationFunctionPropertiesForPasswordVerification, (Object)this.defaultKeyDerivationFunctionPropertiesForPasswordVerification));
    }

    private <T> Class<? extends T> getClass(String configurationKey, Class<T> mustExtend, Class<?> defaultOut) {
        try {
            String value = (String)this.source.getProperty(configurationKey, String.class);
            if (value != null) {
                return Class.forName(value).asSubclass(mustExtend);
            }
        }
        catch (Exception e) {
            this.logger.info("Unable to read configuration for [{}] using default.", (Object)configurationKey);
        }
        return defaultOut.asSubclass(mustExtend);
    }
}

