/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.x509.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.xwiki.crypto.internal.Convert;
import org.xwiki.crypto.passwd.PasswordCryptoService;
import org.xwiki.crypto.x509.XWikiX509Certificate;
import org.xwiki.crypto.x509.XWikiX509KeyPair;
import org.xwiki.crypto.x509.internal.DefaultXWikiX509KeyPair;
import org.xwiki.crypto.x509.internal.X509Keymaker;

public class X509KeyService {
    private final X509Keymaker keymaker = new X509Keymaker();

    public XWikiX509Certificate[] certsFromSpkac(String spkacSerialization, int daysOfValidity, String webID, String userName) throws GeneralSecurityException {
        this.checkWebID(webID);
        if (spkacSerialization == null) {
            throw new InvalidParameterException("SPKAC parameter is null");
        }
        NetscapeCertRequest certRequest = null;
        try {
            certRequest = new NetscapeCertRequest(Convert.fromBase64String(spkacSerialization));
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Failed to parse certificate request", e);
        }
        X509Certificate[] certs = this.keymaker.makeClientAndAuthorityCertificates(certRequest.getPublicKey(), daysOfValidity, true, webID, userName);
        return new XWikiX509Certificate[]{new XWikiX509Certificate(certs[0]), new XWikiX509Certificate(certs[1])};
    }

    public XWikiX509KeyPair newCertAndPrivateKey(int daysOfValidity, String webID, String userName, String password, PasswordCryptoService passwordCryptoService) throws GeneralSecurityException {
        this.checkWebID(webID);
        KeyPair pair = this.keymaker.newKeyPair();
        X509Certificate certificate = this.keymaker.makeClientCertificate(pair.getPublic(), pair, daysOfValidity, false, webID, userName);
        return new DefaultXWikiX509KeyPair(new XWikiX509Certificate(certificate), pair.getPrivate(), password, passwordCryptoService);
    }

    private void checkWebID(String webID) throws GeneralSecurityException {
        try {
            URI uri = new URI(webID);
            if (!uri.isAbsolute()) {
                throw new GeneralSecurityException("webID must be an absolute URI, got: " + webID);
            }
        }
        catch (URISyntaxException e) {
            throw new GeneralSecurityException("webID must be valid URI, got: " + webID, e);
        }
    }
}

