/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.internal.macro.dashboard.DefaultGadgetRenderer;
import org.xwiki.rendering.macro.dashboard.Gadget;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="edit")
@Singleton
public class EditableGadgetRenderer
extends DefaultGadgetRenderer {
    protected static final String METADATA = "metadata";
    @Inject
    @Named(value="annotatedxhtml/1.0")
    protected BlockRenderer gadgetContentRenderer;

    protected Block getGadgetEditMetadata(Gadget gadget) {
        GroupBlock metadataBlock = new GroupBlock();
        metadataBlock.setParameter("class", METADATA);
        boolean isMacro = gadget.getContent().size() == 1 && gadget.getContent().get(0) instanceof MacroBlock;
        GroupBlock isMacroBlock = new GroupBlock();
        isMacroBlock.setParameter("class", "isMacro");
        isMacroBlock.addChild((Block)new WordBlock(Boolean.toString(isMacro)));
        metadataBlock.addChild((Block)isMacroBlock);
        if (isMacro) {
            GroupBlock renderedContentBlock = new GroupBlock();
            renderedContentBlock.setParameter("class", "content");
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.gadgetContentRenderer.render(gadget.getContent(), (WikiPrinter)printer);
            RawBlock rawBlock = new RawBlock(printer.toString(), Syntax.XHTML_1_0);
            renderedContentBlock.addChild((Block)rawBlock);
            GroupBlock gadgetTitleBlock = new GroupBlock();
            gadgetTitleBlock.setParameter("class", "title");
            gadgetTitleBlock.addChild((Block)new WordBlock(gadget.getTitleSource()));
            metadataBlock.addChild((Block)renderedContentBlock);
            metadataBlock.addChild((Block)gadgetTitleBlock);
        }
        return metadataBlock;
    }

    @Override
    public List<Block> decorateGadget(Gadget gadget) {
        List<Block> viewBlock = super.decorateGadget(gadget);
        if (viewBlock.size() > 0) {
            viewBlock.get(0).addChild(this.getGadgetEditMetadata(gadget));
        }
        return viewBlock;
    }
}

