/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.internal.macro.script.NestedScriptMacroEnabled;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.dashboard.DashboardMacroParameters;
import org.xwiki.rendering.macro.dashboard.DashboardRenderer;
import org.xwiki.rendering.macro.dashboard.Gadget;
import org.xwiki.rendering.macro.dashboard.GadgetRenderer;
import org.xwiki.rendering.macro.dashboard.GadgetSource;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;

@Component
@Named(value="dashboard")
@Singleton
public class DashboardMacro
extends AbstractMacro<DashboardMacroParameters>
implements NestedScriptMacroEnabled {
    public static final String GADGET_CONTAINER = "gadget-container";
    public static final String GADGET_CONTAINER_PREFIX = "gadgetcontainer_";
    public static final String METADATA = "metadata";
    public static final String EDIT_URL = "editurl";
    public static final String ADD_URL = "addurl";
    public static final String REMOVE_URL = "removeurl";
    public static final String SOURCE_PAGE = "sourcepage";
    public static final String SOURCE_SPACE = "sourcespace";
    public static final String SOURCE_WIKI = "sourcewiki";
    public static final String SOURCE_URL = "sourceurl";
    public static final String MACRO_NAME = "dashboard";
    private static final String DESCRIPTION = "A macro to define a dashboard.";
    @Inject
    @Named(value="ssfx")
    private SkinExtension ssfx;
    @Inject
    @Named(value="jsfx")
    private SkinExtension jsfx;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private GadgetSource gadgetSource;
    @Inject
    private Logger logger;

    public DashboardMacro() {
        super("Dashboard", DESCRIPTION, DashboardMacroParameters.class);
    }

    public List<Block> execute(DashboardMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> layoutedResult;
        List<Gadget> gadgets;
        try {
            gadgets = this.gadgetSource.getGadgets(parameters.getSource(), context);
        }
        catch (Exception e) {
            String message = "Could not get the gadgets.";
            this.logger.error(message, (Throwable)e);
            throw new MacroExecutionException(message, (Throwable)e);
        }
        boolean isInEditMode = this.gadgetSource.isEditing();
        DashboardRenderer renderer = this.getDashboardRenderer(StringUtils.isEmpty((CharSequence)parameters.getLayout()) ? "columns" : parameters.getLayout());
        if (renderer == null) {
            String message = "Could not find dashboard renderer " + parameters.getLayout();
            this.logger.error(message);
            throw new MacroExecutionException(message);
        }
        GadgetRenderer gadgetRenderer = this.getGadgetRenderer(isInEditMode);
        if (gadgetRenderer == null) {
            String message = "Could not find gadgets renderer.";
            this.logger.error(message);
            throw new MacroExecutionException(message);
        }
        try {
            layoutedResult = renderer.renderGadgets(gadgets, gadgetRenderer, context);
        }
        catch (Exception e) {
            String message = "Could not render the gadgets for layout " + parameters.getLayout();
            this.logger.error(message, (Throwable)e);
            throw new MacroExecutionException(message, (Throwable)e);
        }
        this.includeResources(isInEditMode);
        GroupBlock topLevel = new GroupBlock();
        if (isInEditMode) {
            topLevel.addChildren(this.gadgetSource.getDashboardSourceMetadata(parameters.getSource(), context));
        }
        topLevel.addChildren(layoutedResult);
        topLevel.setParameter("class", MACRO_NAME + (StringUtils.isEmpty((CharSequence)parameters.getStyle()) ? "" : " " + parameters.getStyle()));
        return Collections.singletonList(topLevel);
    }

    protected void includeResources(boolean editMode) {
        HashMap<String, Boolean> fxParamsForceSkinAction = new HashMap<String, Boolean>();
        fxParamsForceSkinAction.put("forceSkinAction", true);
        this.ssfx.use("uicomponents/dashboard/dashboard.css", fxParamsForceSkinAction);
        if (editMode) {
            this.jsfx.use("js/scriptaculous/effects.js");
            this.jsfx.use("js/scriptaculous/dragdrop.js");
            HashMap<String, Boolean> fxParamsNonDeferred = new HashMap<String, Boolean>();
            fxParamsNonDeferred.put("defer", false);
            HashMap<String, Boolean> fxParamsNonDeferredForceSkinAction = new HashMap<String, Boolean>();
            fxParamsNonDeferredForceSkinAction.putAll(fxParamsForceSkinAction);
            fxParamsNonDeferredForceSkinAction.putAll(fxParamsNonDeferred);
            this.jsfx.use("js/smartclient/initsc.js", fxParamsNonDeferredForceSkinAction);
            this.jsfx.use("js/smartclient/modules/ISC_Core.js", fxParamsNonDeferred);
            this.jsfx.use("js/smartclient/overwritesc.js", fxParamsNonDeferred);
            this.jsfx.use("js/smartclient/modules/ISC_Foundation.js", fxParamsNonDeferred);
            this.jsfx.use("js/smartclient/modules/ISC_Containers.js", fxParamsNonDeferred);
            this.jsfx.use("js/smartclient/modules/ISC_Grids.js", fxParamsNonDeferred);
            this.jsfx.use("js/smartclient/modules/ISC_Forms.js", fxParamsNonDeferred);
            this.jsfx.use("js/smartclient/modules/ISC_DataBinding.js", fxParamsNonDeferred);
            this.jsfx.use("js/xwiki/wysiwyg/xwe/XWikiWysiwyg.js", fxParamsNonDeferredForceSkinAction);
            this.jsfx.use("uicomponents/dashboard/dashboard.js", fxParamsForceSkinAction);
        }
    }

    protected DashboardRenderer getDashboardRenderer(String layout) {
        try {
            return (DashboardRenderer)this.componentManager.getInstance(DashboardRenderer.class, layout);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Could not find the Dashboard renderer for layout \"" + layout + "\"");
            return null;
        }
    }

    protected GadgetRenderer getGadgetRenderer(boolean isEditing) {
        String hint = "default";
        if (isEditing) {
            hint = "edit";
        }
        try {
            return (GadgetRenderer)this.componentManager.getInstance(GadgetRenderer.class, hint);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Could not find the Gadgets renderer for hint \"" + hint + "\".");
            return null;
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }
}

