/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.dashboard.Gadget;
import org.xwiki.rendering.macro.dashboard.GadgetSource;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;

@Component
@Singleton
public class DefaultGadgetSource
implements GadgetSource {
    private static final EntityReference GADGET_CLASS = new EntityReference("GadgetClass", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    @Inject
    protected Execution execution;
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<String> currentReferenceResolver;
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<EntityReference> currentReferenceEntityResolver;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private ComponentManager componentManager;

    @Override
    public List<Gadget> getGadgets(String source, MacroTransformationContext context) throws Exception {
        DocumentReference gadgetsClass;
        DocumentReference sourceDocRef = this.getSourceDocumentReference(source);
        if (sourceDocRef == null) {
            return new ArrayList<Gadget>();
        }
        XWikiContext xContext = this.getXWikiContext();
        XWiki xWiki = xContext.getWiki();
        XWikiDocument sourceDoc = xWiki.getDocument(sourceDocRef, xContext);
        List gadgetObjects = sourceDoc.getXObjects(gadgetsClass = this.currentReferenceEntityResolver.resolve((Object)GADGET_CLASS, new Object[0]));
        if (gadgetObjects == null) {
            return new ArrayList<Gadget>();
        }
        return this.prepareGadgets(gadgetObjects, sourceDoc.getSyntax(), context);
    }

    private List<Gadget> prepareGadgets(List<BaseObject> objects, Syntax sourceSyntax, MacroTransformationContext context) throws Exception {
        ArrayList<Gadget> gadgets = new ArrayList<Gadget>();
        VelocityContext velocityContext = this.velocityManager.getVelocityContext();
        String key = context.getTransformationContext().getId();
        if (key == null) {
            key = "unknown namespace";
        }
        VelocityEngine velocityEngine = this.velocityManager.getVelocityEngine();
        Parser contentParser = (Parser)this.componentManager.getInstance(Parser.class, sourceSyntax.toIdString());
        ParserUtils parserUtils = new ParserUtils();
        for (BaseObject xObject : objects) {
            if (xObject == null) continue;
            String title = xObject.getStringValue("title");
            String content = xObject.getLargeStringValue("content");
            String position = xObject.getStringValue("position");
            String id = xObject.getNumber() + "";
            StringWriter writer = new StringWriter();
            velocityEngine.evaluate((Context)velocityContext, (Writer)writer, key, title);
            String gadgetTitle = writer.toString();
            XDOM titleXDom = contentParser.parse((Reader)new StringReader(gadgetTitle));
            List titleBlocks = titleXDom.getChildren();
            parserUtils.removeTopLevelParagraph(titleBlocks);
            XDOM contentXDom = contentParser.parse((Reader)new StringReader(content));
            List contentBlocks = contentXDom.getChildren();
            parserUtils.removeTopLevelParagraph(contentBlocks);
            Gadget gadget = new Gadget(id, titleBlocks, contentBlocks, position);
            gadget.setTitleSource(title);
            gadgets.add(gadget);
        }
        return gadgets;
    }

    private DocumentReference getSourceDocumentReference(String source) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return this.getXWikiContext().getDoc().getDocumentReference();
        }
        return this.currentReferenceResolver.resolve((Object)source, new Object[0]);
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    @Override
    public List<Block> getDashboardSourceMetadata(String source, MacroTransformationContext context) {
        DocumentReference sourceDoc = this.getSourceDocumentReference(source);
        String classParameterName = "class";
        GroupBlock metadataContainer = new GroupBlock();
        metadataContainer.setParameter(classParameterName, "metadata");
        XWikiContext xContext = this.getXWikiContext();
        String editURL = xContext.getWiki().getURL(sourceDoc, "save", "", "", xContext);
        LinkBlock editURLBlock = new LinkBlock(Collections.emptyList(), new ResourceReference(editURL, ResourceType.URL), false);
        editURLBlock.setParameter(classParameterName, "editurl");
        metadataContainer.addChild((Block)editURLBlock);
        String removeURL = xContext.getWiki().getURL(sourceDoc, "objectremove", "", "", xContext);
        LinkBlock removeURLBlock = new LinkBlock(Collections.emptyList(), new ResourceReference(removeURL, ResourceType.URL), false);
        removeURLBlock.setParameter(classParameterName, "removeurl");
        metadataContainer.addChild((Block)removeURLBlock);
        String addURL = xContext.getWiki().getURL(sourceDoc, "objectadd", "", "", xContext);
        LinkBlock addURLBlock = new LinkBlock(Collections.emptyList(), new ResourceReference(addURL, ResourceType.URL), false);
        addURLBlock.setParameter(classParameterName, "addurl");
        metadataContainer.addChild((Block)addURLBlock);
        GroupBlock sourcePageBlock = new GroupBlock();
        sourcePageBlock.addChild((Block)new WordBlock(sourceDoc.getName()));
        sourcePageBlock.setParameter(classParameterName, "sourcepage");
        metadataContainer.addChild((Block)sourcePageBlock);
        GroupBlock sourceSpaceBlock = new GroupBlock();
        sourceSpaceBlock.addChild((Block)new WordBlock(((SpaceReference)sourceDoc.getSpaceReferences().get(0)).getName()));
        sourceSpaceBlock.setParameter(classParameterName, "sourcespace");
        metadataContainer.addChild((Block)sourceSpaceBlock);
        GroupBlock sourceWikiBlock = new GroupBlock();
        sourceWikiBlock.addChild((Block)new WordBlock(sourceDoc.getWikiReference().getName()));
        sourceWikiBlock.setParameter(classParameterName, "sourcewiki");
        metadataContainer.addChild((Block)sourceWikiBlock);
        String sourceURL = xContext.getWiki().getURL(sourceDoc, "view", "", "", xContext);
        LinkBlock sourceURLBlock = new LinkBlock(Collections.emptyList(), new ResourceReference(sourceURL, ResourceType.URL), false);
        sourceURLBlock.setParameter(classParameterName, "sourceurl");
        metadataContainer.addChild((Block)sourceURLBlock);
        return Collections.singletonList(metadataContainer);
    }

    @Override
    public boolean isEditing() {
        XWikiContext context = this.getXWikiContext();
        return "inline".equals(context.getAction()) || "edit".equals(context.getAction());
    }
}

