/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.internal.macro.dashboard.BlocksContainerMacro;
import org.xwiki.rendering.internal.macro.dashboard.ColumnGadget;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.container.ContainerMacroParameters;
import org.xwiki.rendering.macro.dashboard.DashboardRenderer;
import org.xwiki.rendering.macro.dashboard.Gadget;
import org.xwiki.rendering.macro.dashboard.GadgetRenderer;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="columns")
@Singleton
public class ColumnsDashboardRenderer
implements DashboardRenderer {
    protected static final String CLASS = "class";
    protected static final String ID = "id";
    @Inject
    private ComponentManager componentManager;

    @Override
    public List<Block> renderGadgets(List<Gadget> gadgets, GadgetRenderer gadgetsRenderer, MacroTransformationContext context) throws MacroExecutionException {
        int lastGadgetsColumn;
        ArrayList<ColumnGadget> columnGadgets = new ArrayList<ColumnGadget>();
        ArrayList<Gadget> invalidGadgets = new ArrayList<Gadget>();
        for (Gadget gadget : gadgets) {
            ColumnGadget cGadget = new ColumnGadget(gadget);
            if (cGadget.getColumn() != null && cGadget.getIndex() != null) {
                columnGadgets.add(cGadget);
                continue;
            }
            invalidGadgets.add(gadget);
        }
        Collections.sort(columnGadgets, new Comparator<ColumnGadget>(){

            @Override
            public int compare(ColumnGadget g1, ColumnGadget g2) {
                return g1.getColumn().equals(g2.getColumn()) ? g1.getIndex() - g2.getIndex() : g1.getColumn() - g2.getColumn();
            }
        });
        int columns = 1;
        if (!columnGadgets.isEmpty() && (lastGadgetsColumn = ((ColumnGadget)columnGadgets.get(columnGadgets.size() - 1)).getColumn().intValue()) > 1) {
            columns = lastGadgetsColumn;
        }
        ArrayList<Block> gadgetContainers = new ArrayList<Block>();
        for (int i = 0; i < columns; ++i) {
            GroupBlock gContainer = new GroupBlock();
            gContainer.setParameter(CLASS, "gadget-container");
            gContainer.setParameter(ID, "gadgetcontainer_" + (i + 1));
            gadgetContainers.add((Block)gContainer);
        }
        ContainerMacroParameters containerParams = new ContainerMacroParameters();
        containerParams.setLayoutStyle("columns");
        BlocksContainerMacro containerMacro = new BlocksContainerMacro();
        containerMacro.setComponentManager(this.componentManager);
        containerMacro.setContent(gadgetContainers);
        List layoutedResult = containerMacro.execute(containerParams, null, context);
        for (ColumnGadget gadget : columnGadgets) {
            int columnIndex = gadget.getColumn() - 1;
            ((Block)gadgetContainers.get(columnIndex)).addChildren(gadgetsRenderer.decorateGadget(gadget));
        }
        return layoutedResult;
    }
}

