/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.display.internal;

import javax.inject.Singleton;

import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.async.internal.AsyncProperties;

/**
 * Default implementation of {@link DocumentContentAsyncParser}.
 * 
 * @version $Id: 1e958cc3578efc19e6310814b5b5e5f147a3c72a $
 * @since 11.8RC1
 */
@Component
@Singleton
public class DefaultDocumentContentAsyncParser implements DocumentContentAsyncParser
{
    @Override
    public AsyncProperties getAsyncProperties(DocumentModelBridge document)
    {
        return new AsyncProperties();
    }

}
