/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.edit.EditConfiguration;
import org.xwiki.edit.Editor;
import org.xwiki.edit.EditorManager;

@Component
@Singleton
public class DefaultEditorManager
implements EditorManager {
    @Inject
    private EditConfiguration configuration;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public <D> List<Editor<D>> getEditors(Type dataType) {
        DefaultParameterizedType editorType = new DefaultParameterizedType(null, Editor.class, new Type[]{dataType});
        try {
            return ((ComponentManager)this.componentManagerProvider.get()).getInstanceList((Type)editorType);
        }
        catch (ComponentLookupException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public <D> List<Editor<D>> getEditors(Type dataType, String category) {
        ArrayList<Editor<D>> editors = new ArrayList<Editor<D>>();
        for (Editor<D> editor : this.getEditors(dataType)) {
            if (!Objects.equals(category, editor.getDescriptor().getCategory())) continue;
            editors.add(editor);
        }
        return editors;
    }

    @Override
    public <D> Editor<D> getEditor(Type dataType, String hint) {
        DefaultParameterizedType editorType = new DefaultParameterizedType(null, Editor.class, new Type[]{dataType});
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        if (componentManager.hasComponent((Type)editorType, hint)) {
            try {
                return (Editor)componentManager.getInstance((Type)editorType, hint);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(String.format("Failed to look up the [%s] editor with hint [%s]", dataType.getTypeName(), hint), e);
            }
        }
        return null;
    }

    @Override
    public <D> Editor<D> getDefaultEditor(Type dataType) {
        return this.getDefaultEditor(dataType, null);
    }

    @Override
    public <D> Editor<D> getDefaultEditor(Type dataType, String category) {
        Editor<D> defaultEditor;
        String defaultEditorHint = this.configuration.getDefaultEditor(dataType, category);
        if (defaultEditorHint == null) {
            List<Editor<D>> editors = this.getEditors(dataType, category);
            if (editors.isEmpty()) {
                editors = this.getEditors(dataType);
            }
            defaultEditor = editors.isEmpty() ? null : editors.get(0);
        } else {
            defaultEditor = this.getEditorWithFallBackOnCategory(dataType, defaultEditorHint);
        }
        return defaultEditor;
    }

    private <D> Editor<D> getEditorWithFallBackOnCategory(Type dataType, String roleHint) {
        Editor<D> editor = this.getEditor(dataType, roleHint);
        if (editor == null) {
            editor = this.getDefaultEditor(dataType, roleHint);
        }
        return editor;
    }
}

