/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.script;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.edit.EditConfiguration;
import org.xwiki.edit.Editor;
import org.xwiki.edit.EditorManager;
import org.xwiki.script.service.ScriptService;

public abstract class AbstractTypedEditScriptService<D>
implements ScriptService {
    @Inject
    private EditorManager editorManager;
    @Inject
    private EditConfiguration editConfig;

    protected Type getDataType() {
        return ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public List<Editor<D>> getEditors() {
        return this.editorManager.getEditors(this.getDataType());
    }

    public List<Editor<D>> getEditors(String category) {
        return this.editorManager.getEditors(this.getDataType(), category);
    }

    public Editor<D> getEditor(String hint) {
        return this.editorManager.getEditor(this.getDataType(), hint);
    }

    public Editor<D> getDefaultEditor() {
        return this.editorManager.getDefaultEditor(this.getDataType());
    }

    public Editor<D> getDefaultEditor(String category) {
        return this.editorManager.getDefaultEditor(this.getDataType(), category);
    }

    public String getDefaultEditorId() {
        return this.editConfig.getDefaultEditor(this.getDataType());
    }

    public String getDefaultEditorId(String category) {
        return this.editConfig.getDefaultEditor(this.getDataType(), category);
    }
}

