/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.edit.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.edit.DocumentEditConfiguration;

/**
 * Default implementation of {@link DocumentEditConfiguration}.
 * 
 * @version $Id: 97c4040455a6f557113d04caea0b9359c287a47d $
 * @since 12.5
 */
@Component
@Singleton
public class DefaultDocumentEditConfiguration implements DocumentEditConfiguration
{
    @Inject
    @Named("xwikiproperties")
    private ConfigurationSource xwikiProperties;

    @Override
    public boolean inPlaceEditingEnabled()
    {
        return this.xwikiProperties.getProperty("edit.document.inPlaceEditing.enabled", true);
    }
}
