/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.internal.EventStreamWikiCleanerJobRequest;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="EventStreamWikiCleanerJob")
public class EventStreamWikiCleanerJob
extends AbstractJob<EventStreamWikiCleanerJobRequest, DefaultJobStatus<EventStreamWikiCleanerJobRequest>> {
    public static final String JOB_TYPE = "EventStreamWikiCleanerJob";
    @Inject
    private EventStream eventStream;
    @Inject
    private QueryManager queryManager;

    protected void runInternal() throws Exception {
        String wikiId = ((EventStreamWikiCleanerJobRequest)this.request).getWikiId();
        List<Event> eventsToDelete = null;
        do {
            try {
                Query query = this.queryManager.createQuery("where event.wiki = :wiki", "hql");
                query.bindValue("wiki", (Object)wikiId);
                query.setLimit(1024);
                eventsToDelete = this.eventStream.searchEvents(query);
                for (Event toDelete : eventsToDelete) {
                    this.eventStream.deleteEvent(toDelete);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to delete events related to the deleted wiki [{}] in the event stream.", (Object)wikiId, (Object)e);
            }
        } while (eventsToDelete != null && !eventsToDelete.isEmpty());
    }

    public String getType() {
        return JOB_TYPE;
    }
}

