/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.eventstream.Event;

public class EventGroup {
    private Set<Event> events = new LinkedHashSet<Event>();

    public EventGroup() {
    }

    public EventGroup(List<Event> events) {
        if (events != null) {
            this.events.addAll(events);
            this.events.remove(null);
        }
    }

    public EventGroup(Set<Event> events) {
        if (events != null) {
            this.events.addAll(events);
            this.events.remove(null);
        }
    }

    public EventGroup(Event ... events) {
        if (events != null) {
            for (Event e : events) {
                if (e == null) continue;
                this.events.add(e);
            }
        }
    }

    public Set<Event> getEvents() {
        LinkedHashSet<Event> clone = new LinkedHashSet<Event>(this.events.size(), 1.0f);
        clone.addAll(this.events);
        return Collections.unmodifiableSet(clone);
    }

    public void addEvents(Event ... events) {
        for (Event e : events) {
            if (e == null) continue;
            this.events.add(e);
        }
    }

    public void clearEvents() {
        this.events.clear();
    }

    public Event getMainEvent() {
        Event result = null;
        for (Event e : this.events) {
            if (result != null && e.getImportance().ordinal() <= result.getImportance().ordinal()) continue;
            result = e;
        }
        return result;
    }

    public String toString() {
        return this.events.toString();
    }
}

