/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.eventstream.internal.EventStreamConfiguration;
import org.xwiki.eventstream.internal.LegacyEventMigrationRequest;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.Request;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="eventstream.legacycopy")
public class LegacyEventMigrationJob
extends AbstractJob<LegacyEventMigrationRequest, DefaultJobStatus<LegacyEventMigrationRequest>> {
    public static final String JOBTYPE = "eventstream.legacycopy";
    private static final int BATCH_SIZE = 100;
    @Inject
    private EventStreamConfiguration configuration;
    @Inject
    private EventStream eventStream;
    private EventStore eventStore;
    @Inject
    private QueryManager queryManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    protected LegacyEventMigrationRequest castRequest(Request request) {
        LegacyEventMigrationRequest indexerRequest = request instanceof LegacyEventMigrationRequest ? (LegacyEventMigrationRequest)request : new LegacyEventMigrationRequest(request);
        return indexerRequest;
    }

    public String getType() {
        return JOBTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        if (!this.configuration.isEventStoreEnabled() || StringUtils.isEmpty((CharSequence)this.configuration.getEventStore())) {
            this.logger.warn("New event store system is disabled");
            return;
        }
        try {
            this.eventStore = (EventStore)this.componentManager.getInstance(EventStore.class, this.configuration.getEventStore());
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to get the configured store", (Throwable)e);
            return;
        }
        long legacyEventCount = this.eventStream.countEvents();
        int stepCount = (int)(legacyEventCount / 100L);
        if (legacyEventCount % 100L != 0L) {
            ++stepCount;
        }
        this.progressManager.pushLevelProgress(stepCount, (Object)this);
        try {
            List<Event> events;
            Query query = this.prepareQuery();
            int offset = 0;
            do {
                this.progressManager.startStep((Object)this);
                events = this.eventStream.searchEvents(query);
                if (((LegacyEventMigrationRequest)this.getRequest()).isVerbose()) {
                    this.logger.info("Synchronizing legacy events from index {} to {}", (Object)offset, (Object)(offset + events.size()));
                }
                if (!events.isEmpty()) {
                    this.migrate(events);
                    query.setOffset(offset += 100);
                }
                this.progressManager.endStep((Object)this);
            } while (events.size() == 100);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void migrate(List<Event> events) throws EventStreamException, InterruptedException, ExecutionException {
        List<Event> eventsToSave = this.getEventsToSave(events);
        CompletableFuture<?> future = null;
        Iterator<Event> it = eventsToSave.iterator();
        while (it.hasNext()) {
            future = this.migrate(it.next());
        }
        if (future != null) {
            future.get();
        }
        if (((LegacyEventMigrationRequest)this.getRequest()).isVerbose()) {
            this.logger.info("{} events were saved in the new store because they did not already exist", (Object)eventsToSave.size());
        }
    }

    private CompletableFuture<?> migrate(Event event) {
        CompletableFuture<Object> future = this.eventStore.saveEvent(event);
        try {
            List<String> entities = this.getReadEntities(event.getId());
            for (String entity : entities) {
                future = this.eventStore.saveEventStatus(new DefaultEventStatus(event, entity, true));
            }
        }
        catch (QueryException e) {
            this.logger.error("Failed to get read entities associated with event [{}]", (Object)event.getId(), (Object)e);
        }
        return future;
    }

    private List<String> getReadEntities(String eventId) throws QueryException {
        Query query = this.queryManager.createQuery("select eventStatus.entityId from LegacyEventStatus eventStatus where eventStatus.activityEvent.id = :eventId", "hql");
        query.bindValue("eventId", (Object)eventId);
        return query.execute();
    }

    private Query prepareQuery() throws QueryException {
        StringBuilder queryString = new StringBuilder();
        if (((LegacyEventMigrationRequest)this.getRequest()).getSince() != null) {
            queryString.append("WHERE event.date >= :since ");
        }
        queryString.append("ORDER BY event.date desc");
        Query query = this.queryManager.createQuery(queryString.toString(), "hql");
        query.setLimit(100);
        if (((LegacyEventMigrationRequest)this.getRequest()).getSince() != null) {
            query.bindValue("since", (Object)((LegacyEventMigrationRequest)this.getRequest()).getSince());
        }
        return query;
    }

    private List<Event> getEventsToSave(List<Event> events) throws EventStreamException {
        ArrayList<Event> eventsToSave = new ArrayList<Event>(events.size());
        for (Event event : events) {
            try {
                if (this.eventStore.getEvent(event.getId()).isPresent() || event.getWiki() != null && !this.wikiDescriptorManager.exists(event.getWiki().getName())) continue;
                eventsToSave.add(event);
            }
            catch (WikiManagerException e) {
                this.logger.warn("Error while checking if the wiki [{}] exists. The event (id: [{}]) referencing this wiki won't be migrated. Root cause: [{}].", new Object[]{event.getWiki().getName(), event.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
        return eventsToSave;
    }
}

