/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.query.CompareQueryCondition;
import org.xwiki.eventstream.query.GroupQueryCondition;
import org.xwiki.eventstream.query.InQueryCondition;
import org.xwiki.eventstream.query.MailEntityQueryCondition;
import org.xwiki.eventstream.query.PageableEventQuery;
import org.xwiki.eventstream.query.QueryCondition;
import org.xwiki.eventstream.query.SortableEventQuery;
import org.xwiki.eventstream.query.StatusQueryCondition;
import org.xwiki.stability.Unstable;
import org.xwiki.text.XWikiToStringBuilder;

@Unstable
public class SimpleEventQuery
extends GroupQueryCondition
implements PageableEventQuery,
SortableEventQuery {
    private List<QueryCondition> currentConditions;
    private long limit;
    private long offset;
    private List<SortableEventQuery.SortClause> sorts;
    private boolean nextReversed;
    private boolean nextOr;
    private boolean nextOpen;
    private Deque<GroupQueryCondition> groupStack;

    public SimpleEventQuery() {
        super(false, false, new QueryCondition[0]);
        this.currentConditions = this.conditions;
        this.limit = -1L;
        this.sorts = new ArrayList<SortableEventQuery.SortClause>();
        this.groupStack = new LinkedList<GroupQueryCondition>();
    }

    public SimpleEventQuery(long offset, long limit) {
        this();
        this.setOffset(offset);
        this.setLimit(limit);
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    public SimpleEventQuery setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public SimpleEventQuery setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public SimpleEventQuery not() {
        this.nextReversed = true;
        return this;
    }

    public SimpleEventQuery or() {
        this.nextOr(true);
        return this;
    }

    public SimpleEventQuery and() {
        this.nextOr(false);
        return this;
    }

    private void nextOr(boolean or) {
        if (!this.nextOpen && !this.currentConditions.isEmpty()) {
            this.nextOr = or;
        }
    }

    public SimpleEventQuery open() {
        if (this.nextOr) {
            this.forceOpen(true, new QueryCondition[0]);
            this.nextOr = false;
        } else if (this.nextOpen || this.nextReversed) {
            this.forceOpen(false, new QueryCondition[0]);
        } else {
            this.nextOpen = true;
        }
        return this;
    }

    private void forceOpen(boolean or, QueryCondition ... newConditions) {
        GroupQueryCondition group = new GroupQueryCondition(or, this.nextReversed, newConditions);
        this.currentConditions.add(group);
        this.groupStack.push(group);
        this.currentConditions = group.conditions;
        this.nextReversed = false;
    }

    public SimpleEventQuery close() {
        if (this.nextOpen) {
            this.nextOpen = false;
        } else {
            GroupQueryCondition group = this.groupStack.pop();
            List<QueryCondition> list = this.currentConditions = this.groupStack.isEmpty() ? this.conditions : this.groupStack.peek().conditions;
            if (group.getConditions().isEmpty()) {
                this.currentConditions.remove(this.currentConditions.size() - 1);
            } else if (group.getConditions().size() == 1 && group.getConditions().get(0) instanceof GroupQueryCondition) {
                this.currentConditions.set(this.currentConditions.size() - 1, group.getConditions().get(0));
            }
        }
        return this;
    }

    private void addCompareCondition(String property, Object value, CompareQueryCondition.CompareType type) {
        this.addCondition(new CompareQueryCondition(property, value, type, this.nextReversed));
    }

    private void addCondition(QueryCondition newCondition) {
        if (this.nextOpen) {
            this.forceOpen(false, new QueryCondition[0]);
            this.nextOpen = false;
        }
        if (this.nextOr) {
            QueryCondition previousCondition = this.currentConditions.get(this.currentConditions.size() - 1);
            if (previousCondition instanceof GroupQueryCondition && ((GroupQueryCondition)previousCondition).isOr()) {
                ((GroupQueryCondition)previousCondition).conditions.add(newCondition);
            } else {
                this.currentConditions.remove(this.currentConditions.size() - 1);
                this.currentConditions.add(new GroupQueryCondition(true, this.nextReversed, previousCondition, newCondition));
            }
        } else {
            this.currentConditions.add(newCondition);
        }
        this.nextReversed = false;
        this.nextOr = false;
    }

    public SimpleEventQuery eq(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.EQUALS);
        return this;
    }

    public SimpleEventQuery less(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.LESS);
        return this;
    }

    public SimpleEventQuery lessOrEq(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.LESS_OR_EQUALS);
        return this;
    }

    public SimpleEventQuery greater(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.GREATER);
        return this;
    }

    public SimpleEventQuery greaterOrEq(String property, Object value) {
        this.addCompareCondition(property, value, CompareQueryCondition.CompareType.GREATER_OR_EQUALS);
        return this;
    }

    public SimpleEventQuery before(Date date) {
        this.less("date", date);
        return this;
    }

    public SimpleEventQuery after(Date date) {
        this.greater("date", date);
        return this;
    }

    public SimpleEventQuery in(String property, List<?> values) {
        this.addCondition(new InQueryCondition(this.nextReversed, property, values));
        return this;
    }

    public SimpleEventQuery in(String property, Object ... values) {
        return this.in(property, Arrays.asList(values));
    }

    public SimpleEventQuery withStatus(String entityId) {
        this.addCondition(new StatusQueryCondition(entityId, null, this.nextReversed));
        return this;
    }

    public SimpleEventQuery withStatus(String entityId, boolean read) {
        this.addCondition(new StatusQueryCondition(entityId, read, this.nextReversed));
        return this;
    }

    public SimpleEventQuery withStatus(boolean read) {
        this.addCondition(new StatusQueryCondition(null, read, this.nextReversed));
        return this;
    }

    public SimpleEventQuery withMail(String entityId) {
        this.addCondition(new MailEntityQueryCondition(entityId, this.nextReversed));
        return this;
    }

    @Override
    public List<SortableEventQuery.SortClause> getSorts() {
        return this.sorts;
    }

    public SimpleEventQuery addSort(String property, SortableEventQuery.SortClause.Order order) {
        this.sorts.add(new SortableEventQuery.SortClause(property, order));
        return this;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append(this.getLimit());
        builder.append(this.getOffset());
        builder.append(this.getSorts());
        return builder.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SimpleEventQuery) {
            SimpleEventQuery query = (SimpleEventQuery)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.appendSuper(super.equals(obj));
            builder.append(this.getLimit(), query.getLimit());
            builder.append(this.getOffset(), query.getOffset());
            builder.append(this.getSorts(), query.getSorts());
            return builder.build();
        }
        return false;
    }

    @Override
    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("limit", this.getLimit());
        builder.append("offset", this.getOffset());
        builder.append("conditions", this.getConditions());
        builder.append("sorts", this.getSorts());
        return builder.build();
    }
}

