/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

public class DefaultEvent
implements Event {
    private static final MessageFormat STRING_FORMAT = new MessageFormat("{0} at {1,time,yyyy-MM-dd HH:mm:ss} by {2} on {3}");
    private String id;
    private String groupId;
    private String type;
    private Date date;
    private Event.Importance importance = Event.Importance.MEDIUM;
    private String application;
    private String stream;
    private WikiReference wiki;
    private SpaceReference space;
    private DocumentReference document;
    private EntityReference relatedEntity;
    private String documentVersion;
    private String documentTitle;
    private DocumentReference user;
    private URL url;
    private String title;
    private String body;
    private Map<String, String> parameters;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String id) {
        this.groupId = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Event.Importance getImportance() {
        return this.importance;
    }

    @Override
    public void setImportance(Event.Importance importance) {
        this.importance = importance == null ? Event.Importance.MEDIUM : importance;
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public void setApplication(String application) {
        this.application = application;
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @Override
    public void setStream(String stream) {
        this.stream = stream;
    }

    @Override
    public WikiReference getWiki() {
        WikiReference result = null;
        if (this.wiki != null) {
            result = this.wiki;
        } else if (this.space != null) {
            result = (WikiReference)this.space.getRoot();
        } else if (this.document != null) {
            result = this.document.getWikiReference();
        }
        return result;
    }

    @Override
    public void setWiki(WikiReference wiki) {
        this.wiki = wiki;
    }

    @Override
    public SpaceReference getSpace() {
        SpaceReference result = null;
        if (this.space != null) {
            result = this.space;
        } else if (this.document != null) {
            result = this.document.getLastSpaceReference();
        }
        return result;
    }

    @Override
    public void setSpace(SpaceReference space) {
        this.space = space;
    }

    @Override
    public DocumentReference getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(DocumentReference document) {
        this.document = document;
    }

    @Override
    public String getDocumentVersion() {
        return this.documentVersion;
    }

    @Override
    public void setDocumentVersion(String version) {
        this.documentVersion = version;
    }

    @Override
    public EntityReference getRelatedEntity() {
        return this.relatedEntity;
    }

    @Override
    public void setRelatedEntity(EntityReference entity) {
        this.relatedEntity = entity;
    }

    @Override
    public DocumentReference getUser() {
        return this.user;
    }

    @Override
    public void setUser(DocumentReference user) {
        this.user = user;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String getDocumentTitle() {
        return this.documentTitle;
    }

    @Override
    public void setDocumentTitle(String title) {
        this.documentTitle = title;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters != null ? new HashMap<String, String>(parameters) : new HashMap<String, String>();
    }

    public String toString() {
        return STRING_FORMAT.format(new Object[]{this.getType(), this.getDate(), this.getUser(), this.getDocument()});
    }
}

