/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.validator;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionValidator;
import org.xwiki.extension.internal.validator.AbstractExtensionValidator;
import org.xwiki.job.Request;

@Component
@Singleton
public class XWikiExtensionValidator
extends AbstractExtensionValidator {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;

    private ExtensionValidator getExtensionValidator(String type) {
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        if (componentManager.hasComponent(ExtensionValidator.class, type)) {
            try {
                return (ExtensionValidator)componentManager.getInstance(ExtensionValidator.class, type);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get extension validator. Fallback on programming right.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void checkInstallInternal(Extension extension, String namespace, Request request) throws InstallException {
        ExtensionValidator validator = this.getExtensionValidator(extension.getType());
        if (validator != null) {
            validator.checkInstall(extension, namespace, request);
        } else {
            super.checkInstallInternal(extension, namespace, request);
        }
    }

    @Override
    public void checkUninstallInternal(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        ExtensionValidator validator = this.getExtensionValidator(extension.getType());
        if (validator != null) {
            validator.checkUninstall(extension, namespace, request);
        } else {
            super.checkUninstallInternal(extension, namespace, request);
        }
    }
}

