/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.internal.CoreExtensionScanner;
import org.xwiki.extension.repository.internal.DefaultCoreExtension;

@Component
@Singleton
public class DefaultCoreExtensionRepository
extends AbstractExtensionRepository
implements CoreExtensionRepository,
Initializable {
    protected Map<String, DefaultCoreExtension> extensions;
    @Inject
    private Logger logger;
    @Inject
    private CoreExtensionScanner scanner;

    public DefaultCoreExtensionRepository() {
        super(new ExtensionRepositoryId("core", "xwiki-core", null));
    }

    public void initialize() throws InitializationException {
        try {
            this.extensions = this.scanner.loadExtensions(this);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load core extensions", (Throwable)e);
        }
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        CoreExtension extension = this.getCoreExtension(extensionId.getId());
        if (extension == null || extensionId.getVersion() != null && !extension.getId().getVersion().equals(extensionId.getVersion())) {
            throw new ResolveException("Could not find extension [" + extensionId + "]");
        }
        return extension;
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        CoreExtension extension = this.getCoreExtension(extensionId.getId());
        return extension != null && (extensionId.getVersion() == null || extension.getId().getVersion().equals(extensionId.getVersion()));
    }

    @Override
    public boolean exists(String id) {
        return this.extensions.containsKey(id);
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public Collection<CoreExtension> getCoreExtensions() {
        return new ArrayList<CoreExtension>(this.extensions.values());
    }

    @Override
    public CoreExtension getCoreExtension(String id) {
        return this.extensions.get(id);
    }
}

