/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.internal.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.DefaultLocalExtensionRepository;

public class ExtensionSerializer {
    private static final String ELEMENT_ID = "id";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_DEPENDENCY = "dependency";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_SUMMARY = "summary";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_WEBSITE = "website";
    private static final String ELEMENT_AUTHORS = "authors";
    private static final String ELEMENT_AAUTHOR = "author";
    private static final String ELEMENT_DEPENDENCIES = "dependencies";
    private static final String ELEMENT_DDEPENDENCY = "dependency";
    private static final String ELEMENT_FEATURES = "features";
    private static final String ELEMENT_NFEATURE = "feature";
    private static final String ELEMENT_INSTALLED = "installed";
    private static final String ELEMENT_NAMESPACES = "namespaces";
    private static final String ELEMENT_NNAMESPACE = "namespace";
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public DefaultLocalExtension loadDescriptor(DefaultLocalExtensionRepository repository, InputStream descriptor) throws InvalidExtensionException {
        NodeList namespacesNodes;
        Node enabledNode;
        NodeList dependenciesNodes;
        NodeList featuresNodes;
        NodeList authorsNodes;
        Node websiteNode;
        Node descriptionNode;
        Node summaryNode;
        Node nameNode;
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new InvalidExtensionException("Failed to create new DocumentBuilder", e);
        }
        try {
            document = documentBuilder.parse(descriptor);
        }
        catch (Exception e) {
            throw new InvalidExtensionException("Failed to parse descriptor", e);
        }
        Element extensionElement = document.getDocumentElement();
        Node idNode = extensionElement.getElementsByTagName(ELEMENT_ID).item(0);
        Node versionNode = extensionElement.getElementsByTagName(ELEMENT_VERSION).item(0);
        Node typeNode = extensionElement.getElementsByTagName(ELEMENT_TYPE).item(0);
        DefaultLocalExtension localExtension = new DefaultLocalExtension(repository, new ExtensionId(idNode.getTextContent(), versionNode.getTextContent()), typeNode.getTextContent());
        Node dependencyNode = this.getNode(extensionElement, "dependency");
        if (dependencyNode != null) {
            localExtension.setDependency(Boolean.valueOf(dependencyNode.getTextContent()));
        }
        if ((nameNode = this.getNode(extensionElement, ELEMENT_NAME)) != null) {
            localExtension.setName(nameNode.getTextContent());
        }
        if ((summaryNode = this.getNode(extensionElement, ELEMENT_SUMMARY)) != null) {
            localExtension.setSummary(summaryNode.getTextContent());
        }
        if ((descriptionNode = this.getNode(extensionElement, ELEMENT_DESCRIPTION)) != null) {
            localExtension.setDescription(descriptionNode.getTextContent());
        }
        if ((websiteNode = this.getNode(extensionElement, ELEMENT_WEBSITE)) != null) {
            localExtension.setWebsite(websiteNode.getTextContent());
        }
        if ((authorsNodes = extensionElement.getElementsByTagName(ELEMENT_AUTHORS)).getLength() > 0) {
            NodeList authors = authorsNodes.item(0).getChildNodes();
            for (int i = 0; i < authors.getLength(); ++i) {
                Node authorNode = authors.item(i);
                if (authorNode.getNodeName() != ELEMENT_AAUTHOR) continue;
                localExtension.addAuthor(authorNode.getTextContent());
            }
        }
        if ((featuresNodes = extensionElement.getElementsByTagName(ELEMENT_FEATURES)).getLength() > 0) {
            NodeList features = featuresNodes.item(0).getChildNodes();
            for (int i = 0; i < features.getLength(); ++i) {
                Node featureNode = features.item(i);
                if (featureNode.getNodeName() != ELEMENT_NFEATURE) continue;
                localExtension.addFeature(featureNode.getTextContent().trim());
            }
        }
        if ((dependenciesNodes = extensionElement.getElementsByTagName(ELEMENT_DEPENDENCIES)).getLength() > 0) {
            NodeList dependenciesNodeList = dependenciesNodes.item(0).getChildNodes();
            for (int i = 0; i < dependenciesNodeList.getLength(); ++i) {
                Node dependency = dependenciesNodeList.item(i);
                if (!dependency.getNodeName().equals("dependency")) continue;
                Node dependencyIdNode = this.getNode(dependency, ELEMENT_ID);
                Node dependencyVersionNode = this.getNode(dependency, ELEMENT_VERSION);
                localExtension.addDependency(new DefaultExtensionDependency(dependencyIdNode.getTextContent(), dependencyVersionNode.getTextContent()));
            }
        }
        if ((enabledNode = this.getNode(extensionElement, ELEMENT_INSTALLED)) != null) {
            localExtension.setInstalled(Boolean.valueOf(enabledNode.getTextContent()));
        }
        if ((namespacesNodes = extensionElement.getElementsByTagName(ELEMENT_NAMESPACES)).getLength() > 0) {
            NodeList namespaces = namespacesNodes.item(0).getChildNodes();
            for (int i = 0; i < namespaces.getLength(); ++i) {
                Node namespaceNode = namespaces.item(i);
                localExtension.addNamespace(namespaceNode.getTextContent());
            }
        }
        return localExtension;
    }

    private Node getNode(Node parentNode, String elementName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals(elementName)) continue;
            return node;
        }
        return null;
    }

    private Node getNode(Element parentElement, String elementName) {
        NodeList children = parentElement.getElementsByTagName(elementName);
        return children.getLength() > 0 ? children.item(0) : null;
    }

    public void saveDescriptor(LocalExtension extension, FileOutputStream fos) throws ParserConfigurationException, TransformerException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element extensionElement = document.createElement("extension");
        document.appendChild(extensionElement);
        this.addElement(document, extensionElement, ELEMENT_ID, extension.getId().getId());
        this.addElement(document, extensionElement, ELEMENT_VERSION, extension.getId().getVersion());
        this.addElement(document, extensionElement, ELEMENT_TYPE, extension.getType());
        this.addElement(document, extensionElement, "dependency", String.valueOf(extension.isDependency()));
        this.addElement(document, extensionElement, ELEMENT_NAME, extension.getName());
        this.addElement(document, extensionElement, ELEMENT_SUMMARY, extension.getSummary());
        this.addElement(document, extensionElement, ELEMENT_DESCRIPTION, extension.getDescription());
        this.addElement(document, extensionElement, ELEMENT_WEBSITE, extension.getWebSite());
        this.addCollection(document, extensionElement, extension.getAuthors(), ELEMENT_AAUTHOR, ELEMENT_AUTHORS);
        this.addCollection(document, extensionElement, extension.getNamespaces(), ELEMENT_NFEATURE, ELEMENT_FEATURES);
        this.addDependencies(document, extensionElement, extension);
        this.addElement(document, extensionElement, ELEMENT_INSTALLED, String.valueOf(extension.isInstalled()));
        this.addCollection(document, extensionElement, extension.getNamespaces(), ELEMENT_NNAMESPACE, ELEMENT_NAMESPACES);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(fos);
        trans.transform(source, result);
    }

    private void addElement(Document document, Element parentElement, String elementName, String elementValue) {
        Element element = document.createElement(elementName);
        element.setTextContent(elementValue);
        parentElement.appendChild(element);
    }

    private void addDependencies(Document document, Element parentElement, Extension extension) {
        if (extension.getDependencies() != null && !extension.getDependencies().isEmpty()) {
            Element dependenciesElement = document.createElement(ELEMENT_DEPENDENCIES);
            parentElement.appendChild(dependenciesElement);
            for (ExtensionDependency extensionDependency : extension.getDependencies()) {
                Element dependencyElement = document.createElement("dependency");
                dependenciesElement.appendChild(dependencyElement);
                this.addElement(document, dependencyElement, ELEMENT_ID, extensionDependency.getId());
                this.addElement(document, dependencyElement, ELEMENT_VERSION, extensionDependency.getVersion());
            }
        }
    }

    private void addCollection(Document document, Element parentElement, Collection<String> elements, String elementName, String elementRoot) {
        if (elements != null && !elements.isEmpty()) {
            Element wikisElement = document.createElement(elementRoot);
            parentElement.appendChild(wikisElement);
            for (String element : elements) {
                this.addElement(document, wikisElement, elementName, element);
            }
        }
    }
}

