/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.ExtensionRepositorySource;
import org.xwiki.extension.repository.LocalExtensionRepository;

@Component
@Singleton
public class DefaultExtensionManager
implements ExtensionManager,
Initializable {
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private List<ExtensionRepositorySource> repositoriesSources;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        for (ExtensionRepositorySource repositoriesSource : this.repositoriesSources) {
            for (ExtensionRepositoryId repositoryId : repositoriesSource.getExtensionRepositories()) {
                try {
                    this.repositoryManager.addRepository(repositoryId);
                }
                catch (ExtensionRepositoryException e) {
                    this.logger.error("Failed to add repository [" + repositoryId + "]", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Extension resolveExtension(ExtensionId extensionId) throws ResolveException {
        Extension extension = null;
        extension = this.coreExtensionRepository.getCoreExtension(extensionId.getId());
        if (extension == null) {
            try {
                extension = this.localExtensionRepository.resolve(extensionId);
            }
            catch (ResolveException e) {
                extension = this.repositoryManager.resolve(extensionId);
            }
        }
        return extension;
    }

    @Override
    public Extension resolveExtension(ExtensionDependency extensionDependency) throws ResolveException {
        Extension extension;
        block5: {
            extension = null;
            String initialId = extensionDependency.getId();
            String initialVersion = extensionDependency.getVersion();
            extension = this.coreExtensionRepository.getCoreExtension(initialId);
            if (extension == null) {
                try {
                    extension = this.localExtensionRepository.resolve(new ExtensionId(initialId, initialVersion));
                }
                catch (ResolveException e) {
                    extension = this.repositoryManager.resolve(extensionDependency);
                    if (StringUtils.equals((CharSequence)initialVersion, (CharSequence)extension.getId().getVersion())) break block5;
                    try {
                        extension = this.localExtensionRepository.resolve(extension.getId());
                    }
                    catch (ResolveException e2) {
                        // empty catch block
                    }
                }
            }
        }
        return extension;
    }
}

