/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.repository.internal.CoreExtensionScanner;
import org.xwiki.extension.repository.internal.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.DefaultCoreExtensionRepository;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultCoreExtensionScanner
implements CoreExtensionScanner {
    private static final String MAVENPACKAGE = "META-INF.maven";
    private static final String UNKNOWN = "unknown";
    private static final String SNAPSHOTSUFFIX = "-SNAPSHOT";
    @Inject
    private Logger logger;
    @Inject
    private ConverterManager converter;
    @Inject
    private ExtensionLicenseManager licenseManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DefaultCoreExtension> loadExtensions(DefaultCoreExtensionRepository repository) {
        Set mavenURLs = ClasspathHelper.forPackage((String)MAVENPACKAGE, (ClassLoader[])new ClassLoader[0]);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setScanners(new Scanner[]{new ResourcesScanner()});
        configurationBuilder.setUrls((Collection)mavenURLs);
        configurationBuilder.filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)MAVENPACKAGE)));
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set descriptors = reflections.getResources(Predicates.equalTo((Object)"pom.xml"));
        HashMap<String, DefaultCoreExtension> extensions = new HashMap<String, DefaultCoreExtension>(descriptors.size());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        ArrayList<Object[]> coreArtefactIds = new ArrayList<Object[]>();
        for (String descriptor : descriptors) {
            URL descriptorUrl = this.getClass().getClassLoader().getResource(descriptor);
            InputStream descriptorStream = this.getClass().getClassLoader().getResourceAsStream(descriptor);
            try {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model mavenModel = reader.read(descriptorStream);
                String version = this.resolveVersion(mavenModel.getVersion(), mavenModel, false);
                String groupId = this.resolveGroupId(mavenModel.getGroupId(), mavenModel, false);
                String extensionURLStr = descriptorUrl.toString();
                extensionURLStr = extensionURLStr.substring(0, descriptorUrl.toString().indexOf(MAVENPACKAGE.replace('.', '/')));
                URL extensionURL = new URL(extensionURLStr);
                DefaultCoreExtension coreExtension = new DefaultCoreExtension(repository, extensionURL, new ExtensionId(groupId + ':' + mavenModel.getArtifactId(), version), this.packagingToType(mavenModel.getPackaging()));
                coreExtension.setName(mavenModel.getName());
                coreExtension.setDescription(mavenModel.getDescription());
                for (Developer developer : mavenModel.getDevelopers()) {
                    URL authorURL = null;
                    if (developer.getUrl() != null) {
                        try {
                            authorURL = new URL(developer.getUrl());
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                    coreExtension.addAuthor(new DefaultExtensionAuthor(developer.getId(), authorURL));
                }
                coreExtension.setWebsite(mavenModel.getUrl());
                for (License license : mavenModel.getLicenses()) {
                    coreExtension.addLicense(this.getExtensionLicense(license));
                }
                String featuresString = mavenModel.getProperties().getProperty("xwiki.extension.features");
                if (StringUtils.isNotBlank((CharSequence)featuresString)) {
                    coreExtension.setFeatures((Collection)this.converter.convert(List.class, (Object)featuresString));
                }
                coreExtension.putProperty("maven.groupId", groupId);
                coreExtension.putProperty("maven.artifactId", mavenModel.getArtifactId());
                extensions.put(coreExtension.getId().getId(), coreExtension);
                coreArtefactIds.add(new Object[]{mavenModel.getArtifactId(), coreExtension});
                for (Dependency mavenDependency : mavenModel.getDependencies()) {
                    if (!mavenDependency.isOptional() && (mavenDependency.getScope() == null || mavenDependency.getScope().equals("compile") || mavenDependency.getScope().equals("runtime"))) {
                        coreExtension.addDependency(new DefaultExtensionDependency(this.resolveGroupId(mavenDependency.getGroupId(), mavenModel, true) + ':' + mavenDependency.getArtifactId(), this.resolveVersion(mavenDependency.getVersion(), mavenModel, true)));
                    }
                    if (mavenDependency.getGroupId().equals("${project.groupId}")) {
                        mavenDependency.setGroupId(groupId);
                    }
                    if (mavenDependency.getVersion() == null) {
                        mavenDependency.setVersion(UNKNOWN);
                    } else if (mavenDependency.getVersion().equals("${project.version}") || mavenDependency.getVersion().equals("${pom.version}")) {
                        mavenDependency.setVersion(version);
                    }
                    dependencies.add(mavenDependency);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse descriptor [" + descriptorUrl + "], it will be ignored and not found in core extensions.", (Throwable)e);
            }
            finally {
                try {
                    descriptorStream.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close descriptor stream [" + descriptorUrl + "]", (Throwable)e);
                }
            }
        }
        HashMap<String, Object[]> fileNames = new HashMap<String, Object[]>();
        HashMap<String, Object[]> guessedArtefacts = new HashMap<String, Object[]>();
        Set urls = ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[0]);
        for (URL url : urls) {
            try {
                int index;
                String path = url.toURI().getPath();
                String filename = path.substring(path.lastIndexOf(47) + 1);
                int extIndex = filename.lastIndexOf(46);
                if (extIndex != -1) {
                    filename = filename.substring(0, extIndex);
                }
                if ((index = !filename.endsWith(SNAPSHOTSUFFIX) ? filename.lastIndexOf(45) : filename.lastIndexOf(45, filename.length() - SNAPSHOTSUFFIX.length())) == -1) continue;
                fileNames.put(filename, new Object[]{url});
                String artefactname = filename.substring(0, index);
                String version = filename.substring(index + 1);
                guessedArtefacts.put(artefactname, new Object[]{version, url});
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse resource name [" + url + "]", (Throwable)e);
            }
        }
        try {
            DefaultCoreExtension coreExtension;
            for (Object[] coreArtefactId : coreArtefactIds) {
                Object[] artefact = (Object[])guessedArtefacts.get(coreArtefactId[0]);
                coreExtension = (DefaultCoreExtension)coreArtefactId[1];
                if (artefact == null || coreExtension.getId().getVersion().charAt(0) != '$') continue;
                coreExtension.setId(new ExtensionId(coreExtension.getId().getId(), (String)artefact[0]));
                coreExtension.setGuessed(true);
            }
            for (Dependency dependency : dependencies) {
                String dependencyId = dependency.getGroupId() + ':' + dependency.getArtifactId();
                coreExtension = (DefaultCoreExtension)extensions.get(dependencyId);
                if (coreExtension != null) continue;
                String dependencyFileName = dependency.getArtifactId() + '-' + dependency.getVersion();
                if (dependency.getClassifier() != null) {
                    dependencyFileName = dependencyFileName + '-' + dependency.getClassifier();
                    dependencyId = dependencyId + ':' + dependency.getClassifier();
                }
                Object[] filenameArtifact = (Object[])fileNames.get(dependencyFileName);
                Object[] guessedArtefact = (Object[])guessedArtefacts.get(dependency.getArtifactId());
                if (filenameArtifact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)filenameArtifact[0], new ExtensionId(dependencyId, dependency.getVersion()), this.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                } else if (guessedArtefact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)guessedArtefact[1], new ExtensionId(dependencyId, (String)guessedArtefact[0]), this.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension == null) continue;
                extensions.put(dependencyId, coreExtension);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to guess extra information about some extensions", (Throwable)e);
        }
        return extensions;
    }

    private String resolveVersion(String modelVersion, Model mavenModel, boolean dependency) {
        String version = modelVersion;
        if (version == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                version = parent.getVersion();
            }
        } else if (version.startsWith("$")) {
            String propertyName = version.substring(2, version.length() - 1);
            if (propertyName.equals("project.version") || propertyName.equals("pom.version") || propertyName.equals("version")) {
                version = this.resolveVersion(mavenModel.getVersion(), mavenModel, false);
            } else {
                String value = mavenModel.getProperties().getProperty(propertyName);
                if (value != null) {
                    version = value;
                }
            }
        }
        if (version == null) {
            version = UNKNOWN;
        }
        return version;
    }

    private String resolveGroupId(String modelGroupId, Model mavenModel, boolean dependency) {
        String groupId = modelGroupId;
        if (groupId == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                groupId = parent.getGroupId();
            }
        } else if (groupId.startsWith("$")) {
            String propertyName = groupId.substring(2, groupId.length() - 1);
            String value = mavenModel.getProperties().getProperty(propertyName);
            if (value != null) {
                groupId = value;
            }
        }
        if (groupId == null) {
            groupId = UNKNOWN;
        }
        return groupId;
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(license.getName());
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(license.getName(), null);
    }

    private String packagingToType(String packaging) {
        if (packaging.equals("bundle")) {
            return "jar";
        }
        return packaging;
    }
}

