/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.ExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.SearchException;
import org.xwiki.extension.repository.Searchable;

@Component
@Singleton
public class DefaultExtensionRepositoryManager
implements ExtensionRepositoryManager {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private Map<String, ExtensionRepository> repositories = new ConcurrentHashMap<String, ExtensionRepository>();

    @Override
    public ExtensionRepository addRepository(ExtensionRepositoryId repositoryId) throws ExtensionRepositoryException {
        ExtensionRepository repository;
        try {
            ExtensionRepositoryFactory repositoryFactory = (ExtensionRepositoryFactory)this.componentManager.lookup(ExtensionRepositoryFactory.class, repositoryId.getType());
            repository = repositoryFactory.createRepository(repositoryId);
            this.addRepository(repository);
        }
        catch (ComponentLookupException e) {
            throw new ExtensionRepositoryException("Unsupported repository type[" + repositoryId.getType() + "]", e);
        }
        return repository;
    }

    @Override
    public void addRepository(ExtensionRepository repository) {
        this.repositories.put(repository.getId().getId(), repository);
    }

    @Override
    public void removeRepository(String repositoryId) {
        this.repositories.remove(repositoryId);
    }

    @Override
    public ExtensionRepository getRepository(String repositoryId) {
        return this.repositories.get(repositoryId);
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        Extension extension = null;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                extension = repository.resolve(extensionId);
                return extension;
            }
            catch (ResolveException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Could not find extension [{}] in repository [{}]", new Object[]{extensionId, repository.getId(), e});
            }
        }
        throw new ResolveException(MessageFormat.format("Could not find extension [{0}]", extensionId));
    }

    @Override
    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        Extension extension = null;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                extension = repository.resolve(extensionDependency);
                return extension;
            }
            catch (ResolveException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Could not find extension dependency [{}] in repository [{}]", new Object[]{extensionDependency, repository.getId(), e});
            }
        }
        throw new ResolveException(MessageFormat.format("Could not find extension dependency [{0}]", extensionDependency));
    }

    @Override
    public List<Extension> search(String pattern, int offset, int nb) {
        ArrayList<Extension> extensions = new ArrayList<Extension>(nb > 0 ? nb : 0);
        int currentOffset = 0;
        for (ExtensionRepository repository : this.repositories.values()) {
            currentOffset = this.search(extensions, repository, pattern, offset, nb, currentOffset);
        }
        return extensions;
    }

    private int search(List<Extension> extensions, ExtensionRepository repository, String pattern, int offset, int nb, int previousCurrentOffset) {
        int currentOffset = previousCurrentOffset;
        int currentNb = nb - extensions.size();
        if (nb > 0 && currentNb == 0) {
            return currentOffset;
        }
        if (repository instanceof Searchable) {
            Searchable searchableRepository = (Searchable)((Object)repository);
            try {
                List<Extension> foundExtensions = searchableRepository.search(pattern, 0, offset == 0 ? currentNb : -1);
                if (!foundExtensions.isEmpty()) {
                    if (offset - currentOffset >= foundExtensions.size()) {
                        currentOffset += foundExtensions.size();
                    } else {
                        int fromIndex;
                        int toIndex = (fromIndex = offset - currentOffset) + currentNb;
                        extensions.addAll(foundExtensions.subList(fromIndex, toIndex <= 0 || toIndex > foundExtensions.size() ? foundExtensions.size() : toIndex));
                        currentOffset = offset;
                    }
                }
            }
            catch (SearchException e) {
                this.logger.warn("Failed to search in repository [" + this + "]", (Throwable)e);
            }
        }
        return currentOffset;
    }
}

