/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.ExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.search.AggregatedSearchResult;
import org.xwiki.extension.repository.search.CollectionSearchResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.SearchResult;
import org.xwiki.extension.repository.search.Searchable;

@Component
@Singleton
public class DefaultExtensionRepositoryManager
implements ExtensionRepositoryManager {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private Map<String, ExtensionRepository> repositories = new ConcurrentHashMap<String, ExtensionRepository>();

    @Override
    public ExtensionRepository addRepository(ExtensionRepositoryId repositoryId) throws ExtensionRepositoryException {
        ExtensionRepository repository;
        try {
            ExtensionRepositoryFactory repositoryFactory = (ExtensionRepositoryFactory)this.componentManager.lookup(ExtensionRepositoryFactory.class, repositoryId.getType());
            repository = repositoryFactory.createRepository(repositoryId);
            this.addRepository(repository);
        }
        catch (ComponentLookupException e) {
            throw new ExtensionRepositoryException("Unsupported repository type[" + repositoryId.getType() + "]", e);
        }
        return repository;
    }

    @Override
    public void addRepository(ExtensionRepository repository) {
        this.repositories.put(repository.getId().getId(), repository);
    }

    @Override
    public void removeRepository(String repositoryId) {
        this.repositories.remove(repositoryId);
    }

    @Override
    public ExtensionRepository getRepository(String repositoryId) {
        return this.repositories.get(repositoryId);
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        Extension extension = null;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                extension = repository.resolve(extensionId);
                return extension;
            }
            catch (ResolveException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Could not find extension [{}] in repository [{}]", new Object[]{extensionId, repository.getId(), e});
            }
        }
        throw new ResolveException(MessageFormat.format("Could not find extension [{0}]", extensionId));
    }

    @Override
    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        Extension extension = null;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                extension = repository.resolve(extensionDependency);
                return extension;
            }
            catch (ResolveException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Could not find extension dependency [{}] in repository [{}]", new Object[]{extensionDependency, repository.getId(), e});
            }
        }
        throw new ResolveException(MessageFormat.format("Could not find extension dependency [{0}]", extensionDependency));
    }

    @Override
    public SearchResult<Extension> search(String pattern, int offset, int nb) {
        SearchResult<Extension> searchResult = null;
        int currentOffset = offset > 0 ? offset : 0;
        int currentNb = nb;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                if ((searchResult = this.search(repository, pattern, currentOffset, currentNb, searchResult)) == null) continue;
                if (currentOffset > 0 && (currentOffset = offset - searchResult.getTotalHits()) < 0) {
                    currentOffset = 0;
                }
                if (currentNb <= 0 || (currentNb = nb - searchResult.getSize()) >= 0) continue;
                currentNb = 0;
            }
            catch (SearchException e) {
                this.logger.error("Failed to search on repository [{}] with pattern=[{}], offset=[{}] and nb=[{}]. Ignore and got to next repository.", new Object[]{repository, pattern, offset, nb});
            }
        }
        return searchResult != null ? searchResult : new CollectionSearchResult<Extension>(0, offset, Collections.emptyList());
    }

    private SearchResult<Extension> search(ExtensionRepository repository, String pattern, int offset, int nb, SearchResult<Extension> previousSearchResult) throws SearchException {
        AggregatedSearchResult result;
        if (repository instanceof Searchable) {
            Searchable searchableRepository = (Searchable)((Object)repository);
            result = searchableRepository.search(pattern, offset, nb);
            if (previousSearchResult != null) {
                result = this.appendSearchResults(previousSearchResult, result);
            }
        } else {
            result = previousSearchResult;
        }
        return result;
    }

    private AggregatedSearchResult appendSearchResults(SearchResult<Extension> previousSearchResult, SearchResult<Extension> result) {
        AggregatedSearchResult newResult;
        if (previousSearchResult instanceof AggregatedSearchResult) {
            newResult = (AggregatedSearchResult)previousSearchResult;
        } else {
            newResult = new AggregatedSearchResult(previousSearchResult.getOffset());
            newResult.addSearchResult(previousSearchResult);
        }
        newResult.addSearchResult(result);
        return newResult;
    }
}

