/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.internal.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.DefaultLocalExtensionRepository;
import org.xwiki.extension.repository.internal.ExtensionSerializer;

public class ExtensionStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionStorage.class);
    private DefaultLocalExtensionRepository repository;
    private ExtensionSerializer extensionSerializer;
    private File rootFolder;
    private ComponentManager componentManager;

    public ExtensionStorage(DefaultLocalExtensionRepository repository, File rootFolder, ComponentManager componentManager) throws ComponentLookupException {
        this.repository = repository;
        this.rootFolder = rootFolder;
        this.componentManager = componentManager;
        this.extensionSerializer = (ExtensionSerializer)this.componentManager.lookup(ExtensionSerializer.class);
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    protected void loadExtensions() {
        if (this.rootFolder.exists()) {
            FilenameFilter descriptorFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xed");
                }
            };
            for (File child : this.rootFolder.listFiles(descriptorFilter)) {
                if (child.isDirectory()) continue;
                try {
                    DefaultLocalExtension localExtension = this.loadDescriptor(child);
                    this.repository.addLocalExtension(localExtension);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load extension from file [" + child + "] in local repository", (Throwable)e);
                }
            }
        } else {
            this.rootFolder.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultLocalExtension loadDescriptor(File descriptor) throws InvalidExtensionException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(descriptor);
        }
        catch (FileNotFoundException e) {
            throw new InvalidExtensionException("Failed to open descriptor for reading", e);
        }
        try {
            DefaultLocalExtension localExtension = this.extensionSerializer.loadDescriptor(this.repository, fis);
            localExtension.setFile(this.getExtensionFile(localExtension.getId(), localExtension.getType()));
            if (!localExtension.getFile().getFile().exists()) {
                throw new InvalidExtensionException("Failed to load local extension [" + descriptor + "]: [" + localExtension.getFile() + "] file does not exists");
            }
            DefaultLocalExtension defaultLocalExtension = localExtension;
            return defaultLocalExtension;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close stream for file [" + descriptor + "]", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDescriptor(DefaultLocalExtension extension) throws ParserConfigurationException, TransformerException, IOException {
        File file = this.getDescriptorFile(extension.getId());
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.extensionSerializer.saveDescriptor(extension, fos);
        }
        finally {
            fos.close();
        }
    }

    protected File getExtensionFile(ExtensionId id, String type) {
        return new File(this.getRootFolder(), this.getFileName(id, type));
    }

    private File getDescriptorFile(ExtensionId id) {
        return new File(this.getRootFolder(), this.getFileName(id, "xed"));
    }

    private String getFileName(ExtensionId id, String fileExtension) {
        String fileName = id.getId() + "-" + id.getVersion() + "." + fileExtension;
        try {
            return URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return fileName;
        }
    }

    protected void removeExtension(LocalExtension extension) {
        this.getExtensionFile(extension.getId(), extension.getType()).delete();
        this.getDescriptorFile(extension.getId()).delete();
    }
}

