/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xwiki.extension.Extension;
import org.xwiki.extension.repository.search.AggregatedIterator;
import org.xwiki.extension.repository.search.SearchResult;

public class AggregatedSearchResult
implements SearchResult<Extension> {
    private List<SearchResult<Extension>> results = new ArrayList<SearchResult<Extension>>();
    private int offset;
    private Integer totalHits;
    private Integer size;

    public AggregatedSearchResult(int offset) {
        this.offset = offset;
    }

    public void addSearchResult(SearchResult<? extends Extension> result) {
        this.results.add(result);
        this.totalHits = null;
        this.size = null;
    }

    @Override
    public Iterator<Extension> iterator() {
        ArrayList resultItarators = new ArrayList();
        for (SearchResult<Extension> result : this.results) {
            resultItarators.add(result.iterator());
        }
        return new AggregatedIterator<Extension>(resultItarators.iterator());
    }

    @Override
    public int getTotalHits() {
        if (this.totalHits == null) {
            this.totalHits = 0;
            for (SearchResult<Extension> result : this.results) {
                AggregatedSearchResult aggregatedSearchResult = this;
                Integer.valueOf(aggregatedSearchResult.totalHits + result.getTotalHits());
                aggregatedSearchResult.totalHits = aggregatedSearchResult.totalHits;
            }
        }
        return this.totalHits;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        if (this.size == null) {
            this.size = 0;
            for (SearchResult<Extension> result : this.results) {
                AggregatedSearchResult aggregatedSearchResult = this;
                Integer.valueOf(aggregatedSearchResult.size + result.getTotalHits());
                aggregatedSearchResult.size = aggregatedSearchResult.size;
            }
        }
        return this.size;
    }
}

