/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.ExtensionSerializer;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.test.FileExtension;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;

public class FileExtensionRepository
extends AbstractExtensionRepository
implements ExtensionRepository {
    private ExtensionSerializer extensionSerializer;
    private File directory;

    public FileExtensionRepository(File directory, ComponentManager componentManager) throws ComponentLookupException {
        super(new ExtensionRepositoryId("test-file", "file", null));
        this.extensionSerializer = (ExtensionSerializer)componentManager.lookup(ExtensionSerializer.class);
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    InputStream getFileAsStream(ExtensionId extensionId, String type) throws FileNotFoundException, UnsupportedEncodingException {
        return new FileInputStream(this.getFile(extensionId, type));
    }

    public File getFile(ExtensionId extensionId, String type) throws UnsupportedEncodingException {
        File extensionFile = new File(this.directory, this.getEncodedPath(extensionId, type));
        return extensionFile;
    }

    String getEncodedPath(ExtensionId extensionId, String type) throws UnsupportedEncodingException {
        return URLEncoder.encode(this.getPathSuffix(extensionId, type), "UTF-8");
    }

    String getPathSuffix(ExtensionId extensionId, String type) {
        return extensionId.getId() + '-' + extensionId.getVersion().getValue() + '.' + type;
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        InputStream descriptor;
        try {
            descriptor = this.getFileAsStream(extensionId, "xed");
        }
        catch (Exception e) {
            throw new ResolveException("Invalid extension id [" + extensionId + "]", (Throwable)e);
        }
        if (descriptor == null) {
            throw new ResolveException("Extension [" + extensionId + "] not found");
        }
        try {
            DefaultLocalExtension localExtension = this.extensionSerializer.loadDescriptor(null, descriptor);
            return new FileExtension(this, (Extension)localExtension);
        }
        catch (Exception e) {
            throw new ResolveException("Failed to parse descriptor for extension [" + extensionId + "]", (Throwable)e);
        }
    }

    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        return this.resolve(new ExtensionId(extensionDependency.getId(), (Version)new DefaultVersion(extensionDependency.getVersionConstraint().getValue())));
    }

    public boolean exists(ExtensionId extensionId) {
        try {
            return this.getFile(extensionId, "xed").exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        return new CollectionIterableResult(0, offset, Collections.emptyList());
    }
}

