/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jmock.Mockery;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.environment.Environment;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.test.ConfigurableDefaultCoreExtensionRepository;
import org.xwiki.extension.test.ExtensionPackager;
import org.xwiki.extension.test.FileExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.test.MockConfigurationSource;

public class RepositoryUtil {
    private static final String MAVENREPOSITORY_ID = "test-maven";
    private MockConfigurationSource configurationSource;
    private File workingDirectory;
    private File repositoriesDirectory;
    private File localRepositoryRoot;
    private File aetherRepositoryRoot;
    private File mavenRepositoryRoot;
    private File remoteRepositoryRoot;
    private FileExtensionRepository remoteRepository;
    private ComponentManager componentManager;
    private ExtensionPackager extensionPackager;
    private ComponentAnnotationLoader componentLoader;

    public RepositoryUtil(MockConfigurationSource configurationSource, ComponentManager componentManager) {
        this.configurationSource = configurationSource;
        this.componentManager = componentManager;
        this.workingDirectory = new File("target/extension-repositories/" + RandomStringUtils.randomAlphabetic((int)10));
        this.repositoriesDirectory = new File(this.workingDirectory, "repository/");
        this.localRepositoryRoot = new File(this.repositoriesDirectory, "local/");
        this.aetherRepositoryRoot = new File(this.repositoriesDirectory, "aether/");
        this.mavenRepositoryRoot = new File(this.repositoriesDirectory, "maven/");
        this.remoteRepositoryRoot = new File(this.repositoriesDirectory, "remote/");
        this.extensionPackager = new ExtensionPackager(this.workingDirectory, this.remoteRepositoryRoot);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File getLocalRepository() {
        return this.localRepositoryRoot;
    }

    public File getAetherRepository() {
        return this.aetherRepositoryRoot;
    }

    public File getRemoteRepository() {
        return this.remoteRepositoryRoot;
    }

    public File getMavenRepository() {
        return this.mavenRepositoryRoot;
    }

    public String getRemoteRepositoryId() {
        return MAVENREPOSITORY_ID;
    }

    public void setup(Mockery mockery) throws Exception {
        Environment environment = (Environment)mockery.mock(Environment.class);
        DefaultComponentDescriptor dcd = new DefaultComponentDescriptor();
        dcd.setRole(Environment.class);
        this.componentManager.registerComponent((ComponentDescriptor)dcd, (Object)environment);
        this.configurationSource.setProperty("extension.localRepository", (Object)this.getLocalRepository().getAbsolutePath());
        this.configurationSource.setProperty("extension.aether.localRepository", (Object)this.getAetherRepository().getAbsolutePath());
        this.registerComponent(ConfigurableDefaultCoreExtensionRepository.class);
        ((ConfigurableDefaultCoreExtensionRepository)((Object)this.componentManager.lookup(CoreExtensionRepository.class))).addExtensions("coreextension", (Version)new DefaultVersion("version"));
        this.copyResourceFolder(this.getLocalRepository(), "repository.local");
        ExtensionRepositoryManager repositoryManager = (ExtensionRepositoryManager)this.componentManager.lookup(ExtensionRepositoryManager.class);
        if (this.copyResourceFolder(this.getRemoteRepository(), "repository.remote") > 0) {
            this.remoteRepository = new FileExtensionRepository(this.getRemoteRepository(), this.componentManager);
            repositoryManager.addRepository((ExtensionRepository)this.remoteRepository);
        }
        if (this.copyResourceFolder(this.getMavenRepository(), "repository.maven") > 0) {
            repositoryManager.addRepository(new ExtensionRepositoryId(MAVENREPOSITORY_ID, "maven", this.getMavenRepository().toURI()));
        }
        this.extensionPackager.generateExtensions();
        ((ExtensionInitializer)this.componentManager.lookup(ExtensionInitializer.class)).initialize();
    }

    public ComponentAnnotationLoader getComponentLoader() {
        if (this.componentLoader == null) {
            this.componentLoader = new ComponentAnnotationLoader();
        }
        return this.componentLoader;
    }

    private void registerComponent(Class<?> componentClass) throws Exception {
        List descriptors = this.getComponentLoader().getComponentsDescriptors(componentClass);
        for (ComponentDescriptor descriptor : descriptors) {
            this.componentManager.registerComponent(descriptor);
        }
    }

    private void unregisterComponent(Class<?> role, String hint) {
        this.componentManager.unregisterComponent(role, hint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyResourceFolder(File targetFolder, String resourcePackage) throws IOException {
        int nb = 0;
        targetFolder.mkdirs();
        Set urls = ClasspathHelper.forPackage((String)resourcePackage, (ClassLoader[])new ClassLoader[0]);
        if (!urls.isEmpty()) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls((Collection)urls).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)resourcePackage))));
            for (String resource : reflections.getResources(Pattern.compile(".*"))) {
                File targetFile = new File(targetFolder, resource.substring(resourcePackage.length() + 1));
                InputStream resourceStream = this.getClass().getResourceAsStream("/" + resource);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)targetFile);
                    ++nb;
                }
                finally {
                    resourceStream.close();
                }
            }
        }
        return nb;
    }
}

