/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.job.Job;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.event.JobFinishedEvent;
import org.xwiki.extension.job.event.JobStartedEvent;
import org.xwiki.extension.job.event.status.JobStatus;
import org.xwiki.extension.job.event.status.PopLevelProgressEvent;
import org.xwiki.extension.job.event.status.PushLevelProgressEvent;
import org.xwiki.extension.job.event.status.StepProgressEvent;
import org.xwiki.extension.job.internal.DefaultJobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public abstract class AbstractJob<R extends Request>
implements Job {
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected ObservationManager observationManager;
    @Inject
    protected LoggerManager loggerManager;
    @Inject
    protected Logger logger;
    protected DefaultJobStatus<R> status;

    @Override
    public JobStatus getStatus() {
        return this.status;
    }

    public R getRequest() {
        return this.status.getRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Request request) {
        this.observationManager.notify((Event)new JobStartedEvent(this.getId(), this.getType(), request), (Object)this);
        this.status = this.createNewStatus(this.castRequest(request));
        this.status.startListening();
        Exception exception = null;
        try {
            this.start();
        }
        catch (Exception e) {
            this.logger.error("Exception thrown during job execution", (Throwable)e);
            exception = e;
        }
        finally {
            this.status.stopListening();
            this.status.setState(JobStatus.State.FINISHED);
            this.observationManager.notify((Event)new JobFinishedEvent(this.getId(), this.getType(), request), (Object)this, (Object)exception);
        }
    }

    protected R castRequest(Request request) {
        return (R)request;
    }

    protected DefaultJobStatus<R> createNewStatus(R request) {
        return new DefaultJobStatus<R>(request, this.getId(), this.observationManager, this.loggerManager);
    }

    protected String getId() {
        return this.getClass().getName() + "_" + Integer.toHexString(this.hashCode());
    }

    protected void notifyPushLevelProgress(int steps) {
        this.observationManager.notify((Event)new PushLevelProgressEvent(steps), (Object)this);
    }

    protected void notifyStepPropress() {
        this.observationManager.notify((Event)new StepProgressEvent(), (Object)this);
    }

    protected void notifyPopLevelProgress() {
        this.observationManager.notify((Event)new PopLevelProgressEvent(), (Object)this);
    }

    protected abstract void start() throws Exception;
}

