/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.internal.DefaultJobStatus;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanAction;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanNode;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.version.IncompatibleVersionConstraintException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;

@Component
@Named(value="installplan")
public class InstallPlanJob
extends AbstractExtensionJob<InstallRequest> {
    public static final String JOBTYPE = "installplan";
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    private List<ExtensionPlanNode> finalExtensionTree = new ArrayList<ExtensionPlanNode>();
    private List<ModifableExtensionPlanNode> extensionTree = new ArrayList<ModifableExtensionPlanNode>();
    private Map<String, Map<String, ModifableExtensionPlanNode>> extensionsNodeCache = new HashMap<String, Map<String, ModifableExtensionPlanNode>>();

    @Override
    public String getType() {
        return JOBTYPE;
    }

    @Override
    protected DefaultJobStatus<InstallRequest> createNewStatus(InstallRequest request) {
        return new DefaultExtensionPlan<InstallRequest>(request, this.getId(), this.observationManager, this.loggerManager, this.finalExtensionTree);
    }

    @Override
    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws Exception {
        Collection<ExtensionId> extensions = ((InstallRequest)this.getRequest()).getExtensions();
        this.notifyPushLevelProgress(extensions.size());
        try {
            for (ExtensionId extensionId : extensions) {
                if (((InstallRequest)this.getRequest()).hasNamespaces()) {
                    Collection<String> namespaces = ((InstallRequest)this.getRequest()).getNamespaces();
                    this.notifyPushLevelProgress(namespaces.size());
                    try {
                        for (String namespace : namespaces) {
                            this.installExtension(extensionId, namespace, this.extensionTree);
                            this.notifyStepPropress();
                        }
                    }
                    finally {
                        this.notifyPopLevelProgress();
                    }
                } else {
                    this.installExtension(extensionId, null, this.extensionTree);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
        this.finalExtensionTree.addAll(this.createFinalTree(this.extensionTree));
    }

    private List<ExtensionPlanNode> createFinalTree(List<ModifableExtensionPlanNode> tree) {
        ArrayList<ExtensionPlanNode> finalTree = new ArrayList<ExtensionPlanNode>(tree.size());
        for (ModifableExtensionPlanNode node : tree) {
            List<ExtensionPlanNode> children = !node.getChildren().isEmpty() ? this.createFinalTree(node.children) : null;
            DefaultExtensionPlanAction action = new DefaultExtensionPlanAction(node.action.getExtension(), node.action.getPreviousExtension(), node.action.getAction(), node.action.getNamespace(), node.initialDependency != null);
            finalTree.add(new DefaultExtensionPlanNode(action, children, node.initialDependency != null ? node.initialDependency.getVersionConstraint() : null));
        }
        return finalTree;
    }

    private ModifableExtensionPlanNode getExtensionNode(String id, String namespace) {
        ModifableExtensionPlanNode node;
        Map<String, ModifableExtensionPlanNode> extensionsById = this.extensionsNodeCache.get(id);
        if (extensionsById != null && (node = extensionsById.get(namespace)) == null && namespace != null) {
            node = extensionsById.get(null);
        }
        return null;
    }

    private void addExtensionNode(ModifableExtensionPlanNode node) {
        ModifableExtensionPlanNode existingNode;
        String id = node.action.getExtension().getId().getId();
        Map<String, ModifableExtensionPlanNode> extensionsById = this.extensionsNodeCache.get(id);
        if (extensionsById == null) {
            extensionsById = new HashMap<String, ModifableExtensionPlanNode>();
            this.extensionsNodeCache.put(id, extensionsById);
        }
        if ((existingNode = extensionsById.get(node.action.getNamespace())) != null) {
            existingNode.set(node);
            for (ModifableExtensionPlanNode duplicate : existingNode.duplicates) {
                duplicate.set(node);
            }
            existingNode.duplicates.add(node);
        } else {
            extensionsById.put(node.action.getNamespace(), node);
        }
    }

    private void installExtension(ExtensionId extensionId, String namespace, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        this.installExtension(extensionId, false, namespace, parentBranch);
    }

    private void installExtension(ExtensionId extensionId, boolean dependency, String namespace, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        if (namespace != null) {
            this.logger.info("Resolving extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
        } else {
            this.logger.info("Resolving extension [{}]", (Object)extensionId);
        }
        if (this.coreExtensionRepository.exists(extensionId.getId())) {
            throw new InstallException(MessageFormat.format("There is already a core extension with the id [{0}]", extensionId.getId()));
        }
        LocalExtension previousExtension = null;
        LocalExtension localExtension = this.localExtensionRepository.getInstalledExtension(extensionId.getId(), namespace);
        if (localExtension != null) {
            this.logger.info("Found already installed extension with id [{}]. Checking compatibility.", (Object)extensionId);
            if (extensionId.getVersion() == null) {
                throw new InstallException(MessageFormat.format("The extension with id [{0}] is already installed", extensionId.getId()));
            }
            int diff = extensionId.getVersion().compareTo(localExtension.getId().getVersion());
            if (diff == 0) {
                throw new InstallException(MessageFormat.format("The extension [{0}] is already installed", extensionId));
            }
            if (diff < 0) {
                throw new InstallException(MessageFormat.format("A more recent version of [{0}] is already installed", extensionId.getId()));
            }
            previousExtension = localExtension;
        }
        ModifableExtensionPlanNode node = this.installExtension(previousExtension, extensionId, dependency, namespace);
        this.addExtensionNode(node);
        parentBranch.add(node);
    }

    private boolean isCompatible(Version existingVersion, VersionConstraint versionConstraint) {
        boolean compatible = true;
        compatible = versionConstraint.getVersion() == null ? versionConstraint.containsVersion(existingVersion) : existingVersion.compareTo(versionConstraint.getVersion()) >= 0;
        return compatible;
    }

    private boolean checkCoreExtension(ExtensionDependency extensionDependency, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        CoreExtension coreExtension = this.coreExtensionRepository.getCoreExtension(extensionDependency.getId());
        if (coreExtension != null) {
            if (!this.isCompatible(coreExtension.getId().getVersion(), extensionDependency.getVersionConstraint())) {
                throw new InstallException("Dependency [" + extensionDependency + "] is not compatible with core extension [" + coreExtension + "]");
            }
            this.logger.info("There is already a core extension [{}] covering extension dependency [{}]", (Object)coreExtension, (Object)extensionDependency);
            ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, extensionDependency.getVersionConstraint());
            node.action = new DefaultExtensionPlanAction(coreExtension, null, ExtensionPlanAction.Action.NONE, null, true);
            parentBranch.add(node);
            return true;
        }
        return false;
    }

    private VersionConstraint checkExistingPlanNode(ExtensionDependency extensionDependency, String namespace, List<ModifableExtensionPlanNode> parentBranch, VersionConstraint previousVersionConstraint) throws InstallException {
        VersionConstraint versionConstraint = previousVersionConstraint;
        ModifableExtensionPlanNode existingNode = this.getExtensionNode(extensionDependency.getId(), namespace);
        if (existingNode != null) {
            if (this.isCompatible(existingNode.action.getExtension().getId().getVersion(), versionConstraint)) {
                ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, existingNode);
                this.addExtensionNode(node);
                parentBranch.add(node);
                return null;
            }
            if (existingNode.versionConstraint != null) {
                try {
                    versionConstraint = versionConstraint.merge(existingNode.versionConstraint);
                }
                catch (IncompatibleVersionConstraintException e) {
                    throw new InstallException("Dependency [" + extensionDependency + "] is incompatible with current containt [" + existingNode.versionConstraint + "]", e);
                }
            } else {
                throw new InstallException("Dependency [" + extensionDependency + "] incompatible with extension [" + existingNode.action.getExtension() + "]");
            }
        }
        return versionConstraint;
    }

    private ExtensionDependency checkInstalledExtension(LocalExtension installedExtension, ExtensionDependency extensionDependency, VersionConstraint versionConstraint, String namespace, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        ExtensionDependency targetDependency = extensionDependency;
        if (installedExtension != null) {
            VersionConstraint mergedVersionContraint;
            if (this.isCompatible(installedExtension.getId().getVersion(), versionConstraint)) {
                this.logger.info("There is already an installed extension [{}] covering extension dependency [{}]", (Object)installedExtension, (Object)extensionDependency);
                ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, versionConstraint);
                node.action = new DefaultExtensionPlanAction(installedExtension, null, ExtensionPlanAction.Action.NONE, namespace, installedExtension.isDependency());
                this.addExtensionNode(node);
                parentBranch.add(node);
                return null;
            }
            try {
                if (installedExtension.isInstalled(null)) {
                    Map<String, Collection<LocalExtension>> backwardDependencies = this.localExtensionRepository.getBackwardDependencies(installedExtension.getId());
                    mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies.get(null), extensionDependency.getId(), versionConstraint);
                    if (namespace != null) {
                        mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies.get(namespace), extensionDependency.getId(), mergedVersionContraint);
                    }
                } else {
                    Collection<LocalExtension> backwardDependencies = this.localExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace);
                    mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies, extensionDependency.getId(), versionConstraint);
                }
            }
            catch (IncompatibleVersionConstraintException e) {
                throw new InstallException("Provided depency is incompatible with already installed extensions", e);
            }
            catch (ResolveException e) {
                throw new InstallException("Failed to resolve backward dependencies", e);
            }
            if (mergedVersionContraint != versionConstraint) {
                targetDependency = new DefaultExtensionDependency(extensionDependency, mergedVersionContraint);
            }
        }
        return targetDependency;
    }

    private void installExtensionDependency(ExtensionDependency extensionDependency, String namespace, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        if (namespace != null) {
            this.logger.info("Resolving extension dependency [{}] on namespace [{}]", (Object)extensionDependency, (Object)namespace);
        } else {
            this.logger.info("Resolving extension dependency [{}]", (Object)extensionDependency);
        }
        VersionConstraint versionConstraint = extensionDependency.getVersionConstraint();
        if (this.checkCoreExtension(extensionDependency, parentBranch)) {
            return;
        }
        if ((versionConstraint = this.checkExistingPlanNode(extensionDependency, namespace, parentBranch, versionConstraint)) == null) {
            return;
        }
        LocalExtension previousExtension = this.localExtensionRepository.getInstalledExtension(extensionDependency.getId(), namespace);
        ExtensionDependency targetDependency = this.checkInstalledExtension(previousExtension, extensionDependency, versionConstraint, namespace, parentBranch);
        if (targetDependency == null) {
            return;
        }
        ModifableExtensionPlanNode node = this.installExtension(previousExtension, targetDependency, true, namespace);
        node.versionConstraint = versionConstraint;
        this.addExtensionNode(node);
        parentBranch.add(node);
    }

    private ModifableExtensionPlanNode installExtension(LocalExtension previousExtension, ExtensionDependency targetDependency, boolean dependency, String namespace) throws InstallException {
        this.notifyPushLevelProgress(2);
        try {
            Extension extension = this.resolveExtension(targetDependency);
            this.notifyStepPropress();
            try {
                ModifableExtensionPlanNode modifableExtensionPlanNode = this.installExtension(previousExtension, extension, dependency, namespace, targetDependency);
                return modifableExtensionPlanNode;
            }
            catch (Exception e) {
                throw new InstallException("Failed to resolve extension dependency", e);
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private VersionConstraint mergeVersionConstraints(Collection<? extends Extension> extensions, String dependencyId, VersionConstraint previousMergedVersionContraint) throws IncompatibleVersionConstraintException {
        VersionConstraint mergedVersionContraint = previousMergedVersionContraint;
        if (extensions != null) {
            for (Extension extension : extensions) {
                ExtensionDependency dependency = this.getDependency(extension, dependencyId);
                if (dependency == null) continue;
                if (mergedVersionContraint == null) {
                    mergedVersionContraint = dependency.getVersionConstraint();
                    continue;
                }
                mergedVersionContraint = mergedVersionContraint.merge(dependency.getVersionConstraint());
            }
        }
        return mergedVersionContraint;
    }

    private ExtensionDependency getDependency(Extension extension, String dependencyId) {
        for (ExtensionDependency extensionDependency : extension.getDependencies()) {
            if (!extensionDependency.getId().equals(dependencyId)) continue;
            return extensionDependency;
        }
        return null;
    }

    private ModifableExtensionPlanNode installExtension(LocalExtension previousExtension, ExtensionId extensionId, boolean dependency, String namespace) throws InstallException {
        this.notifyPushLevelProgress(2);
        try {
            Extension extension = this.resolveExtension(extensionId);
            this.notifyStepPropress();
            try {
                ModifableExtensionPlanNode modifableExtensionPlanNode = this.installExtension(previousExtension, extension, dependency, namespace, null);
                return modifableExtensionPlanNode;
            }
            catch (Exception e) {
                throw new InstallException("Failed to resolve extension", e);
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private Extension resolveExtension(ExtensionId extensionId) throws InstallException {
        Extension extension;
        try {
            extension = this.localExtensionRepository.resolve(extensionId);
        }
        catch (ResolveException e) {
            this.logger.debug("Can't find extension in local repository, trying to download it.", (Throwable)e);
            try {
                extension = this.repositoryManager.resolve(extensionId);
            }
            catch (ResolveException e1) {
                throw new InstallException(MessageFormat.format("Failed to resolve extension [{0}]", extensionId), e1);
            }
        }
        return extension;
    }

    private Extension resolveExtension(ExtensionDependency extensionDependency) throws InstallException {
        Extension extension;
        try {
            extension = this.localExtensionRepository.resolve(extensionDependency);
        }
        catch (ResolveException e) {
            this.logger.debug("Can't find extension dependency in local repository, trying to download it.", (Throwable)e);
            try {
                extension = this.repositoryManager.resolve(extensionDependency);
            }
            catch (ResolveException e1) {
                throw new InstallException(MessageFormat.format("Failed to resolve extension dependency [{0}]", extensionDependency), e1);
            }
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModifableExtensionPlanNode installExtension(LocalExtension previousExtension, Extension extension, boolean dependency, String namespace, ExtensionDependency initialDependency) throws InstallException {
        Collection<? extends ExtensionDependency> dependencies = extension.getDependencies();
        this.notifyPushLevelProgress(dependencies.size() + 1);
        try {
            ArrayList<ModifableExtensionPlanNode> children = null;
            if (!dependencies.isEmpty()) {
                children = new ArrayList<ModifableExtensionPlanNode>();
                for (ExtensionDependency modifableExtensionPlanNode : extension.getDependencies()) {
                    this.installExtensionDependency(modifableExtensionPlanNode, namespace, children);
                    this.notifyStepPropress();
                }
            }
            ModifableExtensionPlanNode node = initialDependency != null ? new ModifableExtensionPlanNode(initialDependency, initialDependency.getVersionConstraint()) : new ModifableExtensionPlanNode();
            node.children = children;
            node.action = new DefaultExtensionPlanAction(extension, previousExtension, previousExtension != null ? ExtensionPlanAction.Action.UPGRADE : ExtensionPlanAction.Action.INSTALL, namespace, dependency);
            ModifableExtensionPlanNode modifableExtensionPlanNode = node;
            return modifableExtensionPlanNode;
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private static class ModifableExtensionPlanNode {
        private final ExtensionDependency initialDependency;
        public DefaultExtensionPlanAction action;
        public List<ModifableExtensionPlanNode> children;
        public VersionConstraint versionConstraint;
        public final List<ModifableExtensionPlanNode> duplicates = new ArrayList<ModifableExtensionPlanNode>();

        public ModifableExtensionPlanNode() {
            this.initialDependency = null;
        }

        public ModifableExtensionPlanNode(ExtensionDependency initialDependency, VersionConstraint versionConstraint) {
            this.initialDependency = initialDependency;
            this.versionConstraint = versionConstraint;
        }

        public ModifableExtensionPlanNode(ExtensionDependency initialDependency, ModifableExtensionPlanNode node) {
            this.initialDependency = initialDependency;
            this.set(node);
        }

        public void set(ModifableExtensionPlanNode node) {
            this.action = node.action;
            this.children = node.children;
        }

        public List<ModifableExtensionPlanNode> getChildren() {
            return this.children != null ? this.children : Collections.emptyList();
        }
    }
}

