/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.repository.internal.local.DefaultInstalledExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.ExtensionStorage;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;

@Component
@Singleton
public class DefaultLocalExtensionRepository
extends AbstractExtensionRepository
implements LocalExtensionRepository,
Initializable,
Searchable {
    @Inject
    private ExtensionManagerConfiguration configuration;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    private ExtensionStorage storage;
    private Map<ExtensionId, DefaultLocalExtension> extensions = new ConcurrentHashMap<ExtensionId, DefaultLocalExtension>();
    private Map<String, List<DefaultLocalExtension>> extensionsById = new ConcurrentHashMap<String, List<DefaultLocalExtension>>();
    private Map<String, Map<String, DefaultInstalledExtension>> installedExtensions = new ConcurrentHashMap<String, Map<String, DefaultInstalledExtension>>();

    public void initialize() throws InitializationException {
        try {
            this.storage = new ExtensionStorage(this, this.configuration.getLocalRepository(), this.componentManager);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to intialize local extension storage", (Throwable)e);
        }
        this.setId(new ExtensionRepositoryId("local", "xwiki", this.storage.getRootFolder().toURI()));
        this.storage.loadExtensions();
        HashMap<String, Set<String>> validatedExtension = new HashMap<String, Set<String>>();
        for (List<DefaultLocalExtension> extensionVersions : this.extensionsById.values()) {
            ListIterator<DefaultLocalExtension> it = extensionVersions.listIterator(extensionVersions.size());
            while (it.hasPrevious()) {
                DefaultLocalExtension localExtension = it.previous();
                if (!localExtension.isInstalled()) continue;
                this.validateExtension(localExtension, validatedExtension);
            }
        }
    }

    private void validateExtension(DefaultLocalExtension localExtension, Map<String, Set<String>> validatedExtensions) {
        if (localExtension.getNamespaces() == null) {
            this.validateExtension(localExtension, validatedExtensions, null);
        } else {
            for (String namespace : localExtension.getNamespaces()) {
                this.validateExtension(localExtension, validatedExtensions, namespace);
            }
        }
    }

    private void validateExtension(DefaultLocalExtension localExtension, Map<String, Set<String>> validatedExtensions, String namespace) {
        Set<String> validatedExtensionsNamespace = validatedExtensions.get(namespace);
        if (validatedExtensionsNamespace == null) {
            validatedExtensionsNamespace = new HashSet<String>();
            validatedExtensions.put(namespace, validatedExtensionsNamespace);
        }
        if (!validatedExtensionsNamespace.contains(localExtension.getId().getId())) {
            this.validateExtension(localExtension, validatedExtensionsNamespace, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateExtension(DefaultLocalExtension localExtension, Set<String> validatedExtensions, String namespace) {
        try {
            if (!localExtension.isInstalled(namespace)) {
                return;
            }
            if (this.coreExtensionRepository.exists(localExtension.getId().getId())) {
                localExtension.setInstalled(false, namespace);
                this.logger.error("Found local extension [" + localExtension + "] is invalid. Impossible to overwrite core extensions.");
                return;
            }
            for (ExtensionDependency dependency : localExtension.getDependencies()) {
                boolean enabled = false;
                List<DefaultLocalExtension> dependencyVersions = this.extensionsById.get(dependency.getId());
                if (dependencyVersions != null) {
                    ListIterator<DefaultLocalExtension> it = dependencyVersions.listIterator(dependencyVersions.size());
                    while (it.hasPrevious()) {
                        DefaultLocalExtension dependencyExtension = it.previous();
                        if (!validatedExtensions.contains(dependency.getId())) {
                            this.validateExtension(dependencyExtension, validatedExtensions, namespace);
                        }
                        if (!dependencyExtension.isInstalled(namespace)) continue;
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = this.coreExtensionRepository.exists(dependency.getId());
                }
                if (enabled) continue;
                localExtension.setInstalled(false, namespace);
                this.logger.error("Found local extension [" + localExtension + "] is invalid. One of it's dependency ([" + dependency + "]) is not valid and is not a core extension.");
                return;
            }
            this.addInstalledExtension(localExtension, namespace);
        }
        finally {
            validatedExtensions.add(localExtension.getId().getId());
        }
    }

    private void uninstallLocalExtension(DefaultLocalExtension localExtension, String namespace) throws UninstallException {
        localExtension.setInstalled(false, namespace);
        try {
            this.storage.saveDescriptor(localExtension);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to modify extension descriptor", e);
        }
        if (namespace == null) {
            this.installedExtensions.remove(localExtension.getId().getId());
        } else {
            Map<String, DefaultInstalledExtension> namespaceInstalledExtension = this.installedExtensions.get(localExtension.getId().getId());
            namespaceInstalledExtension.remove(namespace);
        }
        this.removeFromBackwardDependencies(localExtension, namespace);
    }

    private void installLocalExtension(DefaultLocalExtension localExtension, String namespace) throws InstallException {
        localExtension.setInstalled(true, namespace);
        try {
            this.storage.saveDescriptor(localExtension);
        }
        catch (Exception e) {
            throw new InstallException("Failed to modify extension descriptor", e);
        }
        this.addInstalledExtension(localExtension, namespace);
    }

    private void removeFromBackwardDependencies(DefaultLocalExtension localExtension, String namespace) {
        for (ExtensionDependency dependency : localExtension.getDependencies()) {
            DefaultInstalledExtension installedExtension;
            if (this.coreExtensionRepository.getCoreExtension(dependency.getId()) != null || (installedExtension = this.getInstalledExtensionFromCache(dependency.getId(), namespace)) != null && !installedExtension.getBackwardDependencies().remove(localExtension)) continue;
            this.logger.warn("Extension [" + localExtension + "] was not regisistered as backward dependency of [" + installedExtension.getExtension() + "]");
        }
    }

    protected void addLocalExtension(DefaultLocalExtension localExtension) {
        this.extensions.put(localExtension.getId(), localExtension);
        List<DefaultLocalExtension> versions = this.extensionsById.get(localExtension.getId().getId());
        if (versions == null) {
            versions = new ArrayList<DefaultLocalExtension>();
            this.extensionsById.put(localExtension.getId().getId(), versions);
            versions.add(localExtension);
        } else {
            int index;
            for (index = 0; index < versions.size() && localExtension.getId().getVersion().compareTo(versions.get(index).getId().getVersion()) < 0; ++index) {
            }
            versions.add(index, localExtension);
        }
    }

    private DefaultInstalledExtension addInstalledExtension(DefaultLocalExtension localExtension, String namespace) {
        DefaultInstalledExtension installedExtension = this.getInstalledExtensionFromCache(localExtension.getId().getId(), namespace, localExtension);
        for (String feature : localExtension.getFeatures()) {
            this.getInstalledExtensionFromCache(feature, namespace, localExtension);
        }
        for (ExtensionDependency dependency : localExtension.getDependencies()) {
            if (this.coreExtensionRepository.exists(dependency.getId())) continue;
            DefaultLocalExtension dependencyLocalExtension = (DefaultLocalExtension)this.getInstalledExtension(dependency.getId(), namespace);
            DefaultInstalledExtension dependencyInstalledExtension = this.getInstalledExtensionFromCache(dependency.getId(), namespace, dependencyLocalExtension);
            dependencyInstalledExtension.addBackwardDependency(localExtension);
        }
        return installedExtension;
    }

    private DefaultInstalledExtension getInstalledExtensionFromCache(String feature, String namespace, DefaultLocalExtension localExtension) {
        DefaultInstalledExtension installedExtension;
        Map<String, DefaultInstalledExtension> installedExtensionsForFeature = this.installedExtensions.get(feature);
        if (installedExtensionsForFeature == null) {
            installedExtensionsForFeature = new HashMap<String, DefaultInstalledExtension>();
            this.installedExtensions.put(feature, installedExtensionsForFeature);
        }
        if ((installedExtension = installedExtensionsForFeature.get(namespace)) == null) {
            installedExtension = new DefaultInstalledExtension(localExtension, feature, namespace);
            installedExtensionsForFeature.put(namespace, installedExtension);
        }
        return installedExtension;
    }

    private DefaultInstalledExtension getInstalledExtensionFromCache(String feature, String namespace) {
        Map<String, DefaultInstalledExtension> installedExtensionsForFeature = this.installedExtensions.get(feature);
        if (installedExtensionsForFeature == null) {
            return null;
        }
        DefaultInstalledExtension installedExtension = installedExtensionsForFeature.get(namespace);
        if (installedExtension == null && namespace != null) {
            installedExtension = this.getInstalledExtensionFromCache(feature, null);
        }
        return installedExtension;
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        LocalExtension localExtension = this.extensions.get(extensionId);
        if (localExtension == null) {
            throw new ResolveException("Can't find extension [" + extensionId + "]");
        }
        return localExtension;
    }

    @Override
    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        List<DefaultLocalExtension> versions = this.extensionsById.get(extensionDependency.getId());
        if (versions != null) {
            for (DefaultLocalExtension extension : versions) {
                if (!extensionDependency.getVersionConstraint().containsVersion(extension.getId().getVersion())) continue;
                return extension;
            }
        }
        throw new ResolveException("Can't find extension dependency [" + extensionDependency + "]");
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        List<DefaultLocalExtension> versions = this.extensionsById.get(id);
        if (versions == null) {
            throw new ResolveException("Can't find extension with id [" + id + "]");
        }
        if (nb == 0 || offset >= versions.size()) {
            return new CollectionIterableResult<Version>(versions.size(), offset, Collections.emptyList());
        }
        int fromId = offset < 0 ? 0 : offset;
        int toId = offset + nb > versions.size() || nb < 0 ? versions.size() - 1 : offset + nb;
        ArrayList<Version> result = new ArrayList<Version>(toId - fromId);
        for (int i = toId - 1; i >= fromId; --i) {
            result.add(versions.get(i).getId().getVersion());
        }
        return new CollectionIterableResult<Version>(versions.size(), offset, result);
    }

    @Override
    public Collection<LocalExtension> getLocalExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    public List<LocalExtension> getInstalledExtensions(String namespace) {
        ArrayList<LocalExtension> result = new ArrayList<LocalExtension>(this.extensions.size());
        for (DefaultLocalExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled(namespace)) continue;
            result.add(localExtension);
        }
        return result;
    }

    public List<LocalExtension> getInstalledExtensions() {
        ArrayList<LocalExtension> result = new ArrayList<LocalExtension>(this.extensions.size());
        for (DefaultLocalExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled()) continue;
            result.add(localExtension);
        }
        return result;
    }

    @Override
    public LocalExtension getInstalledExtension(String feature, String namespace) {
        DefaultInstalledExtension installedExtension = this.getInstalledExtensionFromCache(feature, namespace);
        if (installedExtension != null) {
            return installedExtension.getExtension();
        }
        return null;
    }

    private DefaultLocalExtension createExtension(Extension extension) {
        DefaultLocalExtension localExtension = new DefaultLocalExtension(this, extension);
        localExtension.setFile(this.storage.getNewExtensionFile(localExtension.getId(), localExtension.getType()));
        return localExtension;
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalExtension storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        DefaultLocalExtension localExtension = this.extensions.get(extension.getId());
        if (localExtension == null) {
            try {
                localExtension = this.createExtension(extension);
                InputStream is = extension.getFile().openStream();
                try {
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)localExtension.getFile().getFile());
                }
                finally {
                    is.close();
                }
                this.storage.saveDescriptor(localExtension);
                this.addLocalExtension(localExtension);
            }
            catch (Exception e) {
                throw new LocalExtensionRepositoryException("Failed to save extensoin [" + extension + "] descriptor", e);
            }
        }
        throw new LocalExtensionRepositoryException("Extension [" + extension + "] already exists in local repository");
        return localExtension;
    }

    @Override
    public void removeExtension(LocalExtension extension) throws ResolveException {
        DefaultLocalExtension localExtension = (DefaultLocalExtension)this.resolve(extension.getId());
        try {
            this.storage.removeExtension(localExtension);
        }
        catch (IOException e) {
            this.logger.error("Failed to remove extension [" + extension + "]", (Throwable)e);
        }
    }

    @Override
    public void installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        DefaultLocalExtension localExtension = this.extensions.get(extension.getId());
        if (localExtension != null) {
            if (extension.isInstalled(namespace)) {
                if (localExtension.isDependency() == dependency) {
                    throw new InstallException("The extension [" + localExtension + "] is already installed on namespace [" + namespace + "]");
                }
                localExtension.setDependency(dependency);
            } else {
                if (dependency || localExtension.getProperty("local.dependency") == null) {
                    localExtension.setDependency(dependency);
                }
                this.installLocalExtension(localExtension, namespace);
            }
        } else {
            throw new InstallException("The extension [" + extension + "] need to be stored first");
        }
    }

    @Override
    public void uninstallExtension(LocalExtension localExtension, String namespace) throws UninstallException {
        LocalExtension existingExtension = this.getInstalledExtension(localExtension.getId().getId(), namespace);
        if (existingExtension == localExtension) {
            this.uninstallLocalExtension((DefaultLocalExtension)localExtension, namespace);
        }
    }

    @Override
    public Collection<LocalExtension> getBackwardDependencies(String feature, String namespace) throws ResolveException {
        DefaultInstalledExtension installedExtension;
        if (this.getInstalledExtension(feature, namespace) == null) {
            throw new ResolveException("Extension [" + feature + "] is not installed on namespace [" + namespace + "]");
        }
        Map<String, DefaultInstalledExtension> installedExtensionsByFeature = this.installedExtensions.get(feature);
        if (installedExtensionsByFeature != null && (installedExtension = installedExtensionsByFeature.get(namespace)) != null) {
            Set<DefaultLocalExtension> backwardDependencies = installedExtension.getBackwardDependencies();
            return backwardDependencies != null ? new ArrayList<DefaultLocalExtension>(backwardDependencies) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Collection<LocalExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        Map<String, Collection<LocalExtension>> result;
        DefaultLocalExtension localExtension = (DefaultLocalExtension)this.resolve(extensionId);
        Collection<String> namespaces = localExtension.getNamespaces();
        Map<String, DefaultInstalledExtension> installedExtensionsByFeature = this.installedExtensions.get(localExtension.getId().getId());
        if (installedExtensionsByFeature != null) {
            result = new HashMap();
            for (DefaultInstalledExtension installedExtension : installedExtensionsByFeature.values()) {
                if (namespaces != null && !namespaces.contains(installedExtension.getNamespace()) || installedExtension.getBackwardDependencies().isEmpty()) continue;
                result.put(installedExtension.getNamespace(), new ArrayList<DefaultLocalExtension>(installedExtension.getBackwardDependencies()));
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    @Override
    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        Pattern patternMatcher = Pattern.compile(".*" + pattern + ".*");
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (List<DefaultLocalExtension> versions : this.extensionsById.values()) {
            Extension extension = versions.get(0);
            if (!patternMatcher.matcher(extension.getId().getId()).matches() && !patternMatcher.matcher(extension.getDescription()).matches() && !patternMatcher.matcher(extension.getSummary()).matches() && !patternMatcher.matcher(extension.getName()).matches() && !patternMatcher.matcher(extension.getFeatures().toString()).matches()) continue;
            result.add(extension);
        }
        return new CollectionIterableResult<Extension>(this.extensionsById.size(), offset, result);
    }
}

