/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.reference;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

public class ExtensionResourceReference
extends ResourceReference {
    public static final ResourceType TYPE = new ResourceType("extension");
    public static final String PARAM_REPOSITORYID = "rid";
    public static final String PARAM_REPOSITORYTYPE = "rtype";
    public static final String PARAM_REPOSITORYURI = "ruri";
    private static final String URLENCODING = "UTF-8";
    private String extensionId;
    private String extensionVersion;
    private String repositoryId;
    private String repositoryType;
    private URI repositoryURI;

    public ExtensionResourceReference(String id, String version, String repositoryId) {
        super(ExtensionResourceReference.encode(id) + '/' + ExtensionResourceReference.encode(version) + (repositoryId != null ? "?rid=" + ExtensionResourceReference.encode(repositoryId) : ""), TYPE);
        this.extensionId = id;
        this.extensionVersion = version;
        this.repositoryId = repositoryId;
    }

    public ExtensionResourceReference(String id, String version, String repositoryType, URI repositoryURI) {
        super(ExtensionResourceReference.encode(id) + '/' + ExtensionResourceReference.encode(version) + (repositoryType != null && repositoryURI != null ? "?rtype=" + ExtensionResourceReference.encode(repositoryType) + '&' + PARAM_REPOSITORYURI + '=' + ExtensionResourceReference.encode(repositoryURI.toString()) : ""), TYPE);
        this.extensionId = id;
        this.extensionVersion = version;
        this.repositoryType = repositoryType;
        this.repositoryURI = repositoryURI;
    }

    public ExtensionResourceReference(String reference) {
        super(reference, TYPE);
        int index;
        int queryStringIndex = reference.indexOf(63);
        if (queryStringIndex != -1) {
            String[] parameters;
            for (String parameter : parameters = StringUtils.split((String)reference.substring(queryStringIndex + 1), (char)'&')) {
                int equalIndex = parameter.indexOf(61);
                String parameterName = parameter.substring(0, equalIndex);
                String parameterValue = parameter.substring(equalIndex + 1);
                if (PARAM_REPOSITORYID.equals(parameterName)) {
                    this.repositoryId = parameterValue;
                    continue;
                }
                if (PARAM_REPOSITORYTYPE.equals(parameterName)) {
                    this.repositoryType = parameterValue;
                    continue;
                }
                if (!PARAM_REPOSITORYURI.equals(parameterName)) continue;
                try {
                    this.repositoryURI = new URI(parameterValue);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
        } else {
            queryStringIndex = reference.length();
        }
        if ((index = reference.indexOf(47)) == -1) {
            this.extensionId = ExtensionResourceReference.decode(reference.substring(0, queryStringIndex));
        } else {
            this.extensionId = ExtensionResourceReference.decode(reference.substring(0, index));
            this.extensionVersion = ExtensionResourceReference.decode(reference.substring(index + 1, queryStringIndex));
        }
    }

    private static String encode(String str) {
        try {
            return URLEncoder.encode(str, URLENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported");
        }
    }

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, URLENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 dencoding is not supported");
        }
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public String getExtensionVersion() {
        return this.extensionVersion;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public URI getRepositoryURI() {
        return this.repositoryURI;
    }
}

