/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.extension.job.Request;

public abstract class AbstractRequest
implements Request {
    private Map<String, Object> properties = new HashMap<String, Object>();

    public AbstractRequest() {
    }

    public AbstractRequest(Request request) {
        for (String key : request.getPropertyNames()) {
            this.setProperty(key, request.getProperty(key));
        }
    }

    @Override
    public boolean isRemote() {
        return this.getProperty("remote", false);
    }

    public void setRemote(boolean remote) {
        this.setProperty("remote", remote);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public <T> T getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public <T> T getProperty(String key, T def) {
        Object value = this.properties.get(key);
        return (T)(value != null ? value : def);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }
}

