/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.job.Job;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="uninstall")
public class UninstallJob
extends AbstractExtensionJob<UninstallRequest> {
    public static final String JOBTYPE = "uninstall";
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    @Named(value="uninstallplan")
    private Job uninstallPlanJob;

    @Override
    public String getType() {
        return JOBTYPE;
    }

    @Override
    protected UninstallRequest castRequest(Request request) {
        UninstallRequest uninstallRequest = request instanceof UninstallRequest ? (UninstallRequest)request : new UninstallRequest(request);
        return uninstallRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws Exception {
        this.notifyPushLevelProgress(2);
        try {
            this.uninstallPlanJob.start((Request)this.getRequest());
            ExtensionPlan plan = (ExtensionPlan)this.uninstallPlanJob.getStatus();
            List<LogEvent> log = plan.getLog(LogLevel.ERROR);
            if (!log.isEmpty()) {
                throw new UninstallException("Failed to create install plan: " + log.get(0).getFormattedMessage(), log.get(0).getThrowable());
            }
            this.notifyStepPropress();
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.notifyPushLevelProgress(actions.size());
            try {
                for (ExtensionPlanAction action : actions) {
                    if (action.getAction() != ExtensionPlanAction.Action.NONE) {
                        this.applyAction(action);
                    }
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAction(ExtensionPlanAction action) throws UninstallException {
        if (action.getAction() != ExtensionPlanAction.Action.UNINSTALL) {
            throw new UninstallException("Unsupported action [" + (Object)((Object)action.getAction()) + "]");
        }
        LocalExtension localExtension = (LocalExtension)action.getExtension();
        String namespace = action.getNamespace();
        if (namespace != null) {
            this.logger.info("Uninstalling extension [{}] on namespace [{}]", (Object)localExtension, (Object)namespace);
        } else {
            this.logger.info("Uninstalling extension [{}]", (Object)localExtension);
        }
        this.notifyPushLevelProgress(2);
        try {
            this.extensionHandlerManager.uninstall(localExtension, namespace, this.getExtraHandlerParameters());
            this.notifyStepPropress();
            this.localExtensionRepository.uninstallExtension(localExtension, namespace);
            this.observationManager.notify((Event)new ExtensionUninstalledEvent(localExtension.getId(), namespace), (Object)localExtension);
            if (namespace != null) {
                this.logger.info("Successfully uninstalled extension [{}] on namespace [{}]", (Object)localExtension, (Object)namespace);
            } else {
                this.logger.info("Successfully uninstalled extension [{}]", (Object)localExtension);
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

