/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.internal.DefaultJobStatus;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanAction;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanNode;
import org.xwiki.extension.repository.LocalExtensionRepository;

@Component
@Named(value="uninstallplan")
public class UninstallPlanJob
extends AbstractExtensionJob<UninstallRequest> {
    public static final String JOBTYPE = "uninstallplan";
    private static final String EXCEPTION_NOTINSTALLED = "Extension [{0}] is not installed";
    private static final String EXCEPTION_NOTINSTALLEDNAMESPACE = "Extension [{0}] is not installed on namespace [{1}]";
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    private List<ExtensionPlanNode> extensionTree = new ArrayList<ExtensionPlanNode>();

    @Override
    public String getType() {
        return JOBTYPE;
    }

    @Override
    protected DefaultJobStatus<UninstallRequest> createNewStatus(UninstallRequest request) {
        return new DefaultExtensionPlan<UninstallRequest>(request, this.getId(), this.observationManager, this.loggerManager, this.extensionTree);
    }

    @Override
    protected UninstallRequest castRequest(Request request) {
        UninstallRequest uninstallRequest = request instanceof UninstallRequest ? (UninstallRequest)request : new UninstallRequest(request);
        return uninstallRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws Exception {
        Collection<ExtensionId> extensions = ((UninstallRequest)this.getRequest()).getExtensions();
        this.notifyPushLevelProgress(extensions.size());
        try {
            for (ExtensionId extensionId : extensions) {
                if (extensionId.getVersion() != null) {
                    LocalExtension localExtension = (LocalExtension)this.localExtensionRepository.resolve(extensionId);
                    if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                        this.uninstallExtension(localExtension, ((UninstallRequest)this.getRequest()).getNamespaces(), this.extensionTree);
                    } else if (localExtension.getNamespaces() != null) {
                        this.uninstallExtension(localExtension, new ArrayList<String>(localExtension.getNamespaces()), this.extensionTree);
                    } else {
                        this.uninstallExtension(localExtension, (String)null, this.extensionTree);
                    }
                } else if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                    this.uninstallExtension(extensionId.getId(), ((UninstallRequest)this.getRequest()).getNamespaces(), this.extensionTree);
                } else {
                    this.uninstallExtension(extensionId.getId(), (String)null, this.extensionTree);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallExtension(String extensionId, Collection<String> namespaces, List<ExtensionPlanNode> parentBranch) throws UninstallException {
        this.notifyPushLevelProgress(namespaces.size());
        try {
            for (String namespace : namespaces) {
                this.uninstallExtension(extensionId, namespace, parentBranch);
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private void uninstallExtension(String extensionId, String namespace, List<ExtensionPlanNode> parentBranch) throws UninstallException {
        LocalExtension localExtension = this.localExtensionRepository.getInstalledExtension(extensionId, namespace);
        if (localExtension == null) {
            throw new UninstallException(MessageFormat.format(EXCEPTION_NOTINSTALLED, extensionId));
        }
        try {
            this.uninstallExtension(localExtension, namespace, parentBranch);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to uninstall extension", e);
        }
    }

    private void uninstallExtension(LocalExtension localExtension, Collection<String> namespaces, List<ExtensionPlanNode> parentBranch) throws UninstallException {
        for (String namespace : namespaces) {
            this.uninstallExtension(localExtension, namespace, parentBranch);
        }
    }

    private void uninstallExtensions(Collection<LocalExtension> extensions, String namespace, List<ExtensionPlanNode> parentBranch) throws UninstallException {
        for (LocalExtension backardDependency : extensions) {
            this.uninstallExtension(backardDependency, namespace, parentBranch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallExtension(LocalExtension localExtension, String namespace, List<ExtensionPlanNode> parentBranch) throws UninstallException {
        if (!localExtension.isInstalled()) {
            throw new UninstallException(MessageFormat.format(EXCEPTION_NOTINSTALLED, localExtension, namespace));
        }
        if (!(namespace == null || localExtension.getNamespaces() != null && localExtension.getNamespaces().contains(namespace))) {
            throw new UninstallException(MessageFormat.format(EXCEPTION_NOTINSTALLEDNAMESPACE, localExtension, namespace));
        }
        if (namespace != null) {
            this.logger.info("Resolving extension [{}] from namespace [{}]", (Object)localExtension, (Object)namespace);
        } else {
            this.logger.info("Resolving extension [{}]", (Object)localExtension);
        }
        this.notifyPushLevelProgress(2);
        try {
            ArrayList<ExtensionPlanNode> children = new ArrayList<ExtensionPlanNode>();
            try {
                if (namespace != null) {
                    this.uninstallExtensions(this.localExtensionRepository.getBackwardDependencies(localExtension.getId().getId(), namespace), namespace, children);
                } else {
                    for (Map.Entry<String, Collection<LocalExtension>> entry : this.localExtensionRepository.getBackwardDependencies(localExtension.getId()).entrySet()) {
                        this.uninstallExtensions(entry.getValue(), entry.getKey(), children);
                    }
                }
            }
            catch (ResolveException e) {
                throw new UninstallException("Failed to resolve backward dependencies of extension [" + localExtension + "]", e);
            }
            this.notifyStepPropress();
            DefaultExtensionPlanAction action = new DefaultExtensionPlanAction(localExtension, null, ExtensionPlanAction.Action.UNINSTALL, namespace, false);
            parentBranch.add(new DefaultExtensionPlanNode(action, children, null));
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

