/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.distribution.internal.job.step;

import javax.inject.Inject;
import javax.inject.Named;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.platform.flavor.FlavorManager;

/**
 * Install and upgrade flavor extension.
 * 
 * @version $Id: 8c7878e4f1e93121e2b1d7fceb61f97d3d7ed56f $
 * @since 7.1M1
 */
@Component
@Named(FlavorDistributionStep.ID)
@InstantiationStrategy(ComponentInstantiationStrategy.PER_LOOKUP)
public class FlavorDistributionStep extends AbstractDistributionStep
{
    /**
     * ID of the distribution step.
     */
    public static final String ID = "extension.flavor";

    /**
     * The flavor manager.
     */
    @Inject
    private transient FlavorManager flavorManager;

    /**
     * Constructs a new FlavorDistributionStep.
     */
    public FlavorDistributionStep()
    {
        super(ID);
    }

    @Override
    public void prepare()
    {
        if (getState() == null) {
            InstalledExtension flavor = this.flavorManager.getFlavorExtension(getNamespace());
            if (flavor != null && flavor.isValid(getNamespace().toString())) {
                setState(State.COMPLETED);
            }
        }
    }
}
